/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.dao.impl;

import java.io.IOException;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.nifi.authorization.user.NiFiUser;
import org.apache.nifi.registry.bucket.Bucket;
import org.apache.nifi.registry.client.NiFiRegistryException;
import org.apache.nifi.registry.flow.FlowRegistry;
import org.apache.nifi.registry.flow.FlowRegistryClient;
import org.apache.nifi.registry.flow.VersionedFlow;
import org.apache.nifi.registry.flow.VersionedFlowSnapshotMetadata;
import org.apache.nifi.web.NiFiCoreException;
import org.apache.nifi.web.ResourceNotFoundException;
import org.apache.nifi.web.api.dto.RegistryDTO;
import org.apache.nifi.web.dao.RegistryDAO;

public class FlowRegistryDAO
implements RegistryDAO {
    private FlowRegistryClient flowRegistryClient;

    public FlowRegistry createFlowRegistry(RegistryDTO registryDto) {
        return this.flowRegistryClient.addFlowRegistry(registryDto.getId(), registryDto.getName(), registryDto.getUri(), registryDto.getDescription());
    }

    public FlowRegistry getFlowRegistry(String registryId) {
        FlowRegistry registry = this.flowRegistryClient.getFlowRegistry(registryId);
        if (registry == null) {
            throw new ResourceNotFoundException("Unable to find Flow Registry with id '" + registryId + "'");
        }
        return registry;
    }

    public Set<FlowRegistry> getFlowRegistries() {
        return this.flowRegistryClient.getRegistryIdentifiers().stream().map(arg_0 -> ((FlowRegistryClient)this.flowRegistryClient).getFlowRegistry(arg_0)).collect(Collectors.toSet());
    }

    public Set<FlowRegistry> getFlowRegistriesForUser(NiFiUser user) {
        return this.getFlowRegistries();
    }

    public Set<Bucket> getBucketsForUser(String registryId, NiFiUser user) {
        try {
            FlowRegistry flowRegistry = this.flowRegistryClient.getFlowRegistry(registryId);
            if (flowRegistry == null) {
                throw new IllegalArgumentException("The specified registry id is unknown to this NiFi.");
            }
            Set buckets = flowRegistry.getBuckets(user);
            TreeSet<Bucket> sortedBuckets = new TreeSet<Bucket>((b1, b2) -> b1.getName().compareTo(b2.getName()));
            sortedBuckets.addAll(buckets);
            return sortedBuckets;
        }
        catch (IOException | NiFiRegistryException ioe) {
            throw new NiFiCoreException("Unable to obtain listing of buckets: " + ioe, ioe);
        }
    }

    public Set<VersionedFlow> getFlowsForUser(String registryId, String bucketId, NiFiUser user) {
        try {
            FlowRegistry flowRegistry = this.flowRegistryClient.getFlowRegistry(registryId);
            if (flowRegistry == null) {
                throw new IllegalArgumentException("The specified registry id is unknown to this NiFi.");
            }
            Set flows = flowRegistry.getFlows(bucketId, user);
            TreeSet<VersionedFlow> sortedFlows = new TreeSet<VersionedFlow>((f1, f2) -> f1.getName().compareTo(f2.getName()));
            sortedFlows.addAll(flows);
            return sortedFlows;
        }
        catch (IOException | NiFiRegistryException ioe) {
            throw new NiFiCoreException("Unable to obtain listing of flows for bucket with ID " + bucketId + ": " + ioe, ioe);
        }
    }

    public Set<VersionedFlowSnapshotMetadata> getFlowVersionsForUser(String registryId, String bucketId, String flowId, NiFiUser user) {
        try {
            FlowRegistry flowRegistry = this.flowRegistryClient.getFlowRegistry(registryId);
            if (flowRegistry == null) {
                throw new IllegalArgumentException("The specified registry id is unknown to this NiFi.");
            }
            Set flowVersions = flowRegistry.getFlowVersions(bucketId, flowId, user);
            TreeSet<VersionedFlowSnapshotMetadata> sortedFlowVersions = new TreeSet<VersionedFlowSnapshotMetadata>((f1, f2) -> Integer.compare(f1.getVersion(), f2.getVersion()));
            sortedFlowVersions.addAll(flowVersions);
            return sortedFlowVersions;
        }
        catch (IOException | NiFiRegistryException ioe) {
            throw new NiFiCoreException("Unable to obtain listing of versions for bucket with ID " + bucketId + " and flow with ID " + flowId + ": " + ioe, ioe);
        }
    }

    public FlowRegistry removeFlowRegistry(String registryId) {
        FlowRegistry registry = this.flowRegistryClient.removeFlowRegistry(registryId);
        if (registry == null) {
            throw new ResourceNotFoundException("Unable to find Flow Registry with id '" + registryId + "'");
        }
        return registry;
    }

    public void setFlowRegistryClient(FlowRegistryClient client) {
        this.flowRegistryClient = client;
    }
}

