/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.result.registry;

import java.io.PrintStream;
import java.util.List;
import java.util.Objects;
import org.apache.nifi.registry.authorization.User;
import org.apache.nifi.toolkit.cli.api.ResultType;
import org.apache.nifi.toolkit.cli.impl.result.AbstractWritableResult;
import org.apache.nifi.toolkit.cli.impl.result.writer.DynamicTableWriter;
import org.apache.nifi.toolkit.cli.impl.result.writer.Table;

public class UsersResult
extends AbstractWritableResult<List<User>> {
    private final List<User> users;

    public UsersResult(ResultType resultType, List<User> users) {
        super(resultType);
        this.users = Objects.requireNonNull(users);
    }

    @Override
    public List<User> getResult() {
        return this.users;
    }

    @Override
    protected void writeSimpleResult(PrintStream output) {
        if (this.users.isEmpty()) {
            return;
        }
        Table table = new Table.Builder().column("#", 3, 3, false).column("Name", 20, 36, true).column("Id", 36, 36, false).build();
        for (int userIndex = 0; userIndex < this.users.size(); ++userIndex) {
            User user = this.users.get(userIndex);
            table.addRow(String.valueOf(userIndex + 1), user.getIdentity(), user.getIdentifier());
        }
        DynamicTableWriter tableWriter = new DynamicTableWriter();
        tableWriter.write(table, output);
    }
}

