/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.tests.system;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.Validator;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.stream.io.StreamUtils;

public class VerifyContents
extends AbstractProcessor {
    private static final Relationship REL_UNMATCHED = new Relationship.Builder().name("unmatched").build();
    private final AtomicReference<Set<Relationship>> relationshipsRef = new AtomicReference<Set<Relationship>>(Collections.singleton(REL_UNMATCHED));

    protected PropertyDescriptor getSupportedDynamicPropertyDescriptor(String propertyDescriptorName) {
        return new PropertyDescriptor.Builder().name(propertyDescriptorName).dynamic(true).addValidator(Validator.VALID).build();
    }

    public void onPropertyModified(PropertyDescriptor descriptor, String oldValue, String newValue) {
        Relationship relationship = new Relationship.Builder().name(descriptor.getName()).build();
        HashSet<Relationship> updatedRelationships = new HashSet<Relationship>((Collection)this.relationshipsRef.get());
        if (newValue == null) {
            updatedRelationships.remove(relationship);
        } else {
            updatedRelationships.add(relationship);
        }
        updatedRelationships.add(REL_UNMATCHED);
        this.relationshipsRef.set(updatedRelationships);
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        String contents;
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        try (InputStream in = session.read(flowFile);
             ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            StreamUtils.copy((InputStream)in, (OutputStream)baos);
            contents = new String(baos.toByteArray(), StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            throw new ProcessException((Throwable)e);
        }
        for (Map.Entry entry : context.getProperties().entrySet()) {
            String propertyName = ((PropertyDescriptor)entry.getKey()).getName();
            if (!contents.equals(entry.getValue())) continue;
            this.getLogger().info("Routing {} to {}", new Object[]{flowFile, propertyName});
            session.transfer(flowFile, new Relationship.Builder().name(propertyName).build());
            return;
        }
        this.getLogger().info("Routing {} to {}", new Object[]{flowFile, REL_UNMATCHED});
        session.transfer(flowFile, REL_UNMATCHED);
    }
}

