/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.tests.system;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.FlowFileFilter;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;

public class ThrowExceptionInFlowFileFilter
extends AbstractProcessor {
    static final PropertyDescriptor THROW_EXCEPTION = new PropertyDescriptor.Builder().name("Throw Exception").description("If true, the processor will throw an exception for each FlowFile that is processed").required(true).allowableValues(new String[]{"true", "false"}).defaultValue("true").build();
    private static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS = List.of(THROW_EXCEPTION);
    static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("All FlowFiles are routed to this Relationship").build();
    private static final Set<Relationship> RELATIONSHIPS = Set.of(REL_SUCCESS);

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    public Set<Relationship> getRelationships() {
        return RELATIONSHIPS;
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        final boolean throwException = context.getProperty(THROW_EXCEPTION).asBoolean();
        List flowFiles = session.get(new FlowFileFilter(){

            public FlowFileFilter.FlowFileFilterResult filter(FlowFile flowFile) {
                if (throwException) {
                    throw new ProcessException("Throwing exception as configured");
                }
                return FlowFileFilter.FlowFileFilterResult.ACCEPT_AND_CONTINUE;
            }
        });
        session.transfer((Collection)flowFiles, REL_SUCCESS);
    }
}

