/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.tests.system;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;

public class SplitTextByLine
extends AbstractProcessor {
    static final Relationship ORIGINAL = new Relationship.Builder().name("original").build();
    static final Relationship SPLITS = new Relationship.Builder().name("splits").build();
    static final Relationship FAILURE = new Relationship.Builder().name("failure").build();

    public Set<Relationship> getRelationships() {
        return new HashSet<Relationship>(Arrays.asList(ORIGINAL, SPLITS, FAILURE));
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        ArrayList<String> splits = new ArrayList<String>();
        try (InputStream in = session.read(flowFile);
             InputStreamReader streamReader = new InputStreamReader(in);
             BufferedReader reader = new BufferedReader(streamReader);){
            String line;
            while ((line = reader.readLine()) != null) {
                splits.add(line);
            }
        }
        catch (IOException ioe) {
            session.transfer(flowFile, FAILURE);
        }
        long offset = 0L;
        for (String splitText : splits) {
            FlowFile splitFlowFile = session.clone(flowFile, offset, (long)splitText.getBytes(StandardCharsets.UTF_8).length);
            offset += (long)splitText.getBytes(StandardCharsets.UTF_8).length;
            splitFlowFile = session.write(splitFlowFile, out -> out.write(splitText.getBytes(StandardCharsets.UTF_8)));
            session.transfer(splitFlowFile, SPLITS);
        }
        session.transfer(flowFile, ORIGINAL);
    }
}

