/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.tests.system;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.stream.io.util.TextLineDemarcator;

public class SplitByLine
extends AbstractProcessor {
    static final PropertyDescriptor USE_CLONE = new PropertyDescriptor.Builder().name("Use Clone").description("Whether or not to use session.clone for generating children FlowFiles").required(true).defaultValue("true").allowableValues(new String[]{"true", "false"}).build();
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").build();

    public Set<Relationship> getRelationships() {
        return Collections.singleton(REL_SUCCESS);
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return Collections.singletonList(USE_CLONE);
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        boolean clone = context.getProperty(USE_CLONE).asBoolean();
        if (clone) {
            this.splitByClone(session, flowFile);
        } else {
            this.splitByWrite(session, flowFile);
        }
        session.remove(flowFile);
    }

    private void splitByClone(ProcessSession session, FlowFile flowFile) {
        ArrayList<TextLineDemarcator.OffsetInfo> offsetInfos = new ArrayList<TextLineDemarcator.OffsetInfo>();
        try (InputStream in = session.read(flowFile);
             TextLineDemarcator demarcator = new TextLineDemarcator(in);){
            TextLineDemarcator.OffsetInfo offsetInfo;
            while ((offsetInfo = demarcator.nextOffsetInfo()) != null) {
                offsetInfos.add(offsetInfo);
            }
        }
        catch (Exception e) {
            throw new ProcessException((Throwable)e);
        }
        for (TextLineDemarcator.OffsetInfo offsetInfo : offsetInfos) {
            FlowFile child = session.clone(flowFile, offsetInfo.getStartOffset(), offsetInfo.getLength() - (long)offsetInfo.getCrlfLength());
            session.putAttribute(child, "num.lines", String.valueOf(offsetInfos.size()));
            session.transfer(child, REL_SUCCESS);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void splitByWrite(ProcessSession session, FlowFile flowFile) {
        ArrayList<FlowFile> children = new ArrayList<FlowFile>();
        try (InputStream in = session.read(flowFile);
             BufferedReader reader = new BufferedReader(new InputStreamReader(in));){
            String line;
            while ((line = reader.readLine()) != null) {
                FlowFile child = session.create(flowFile);
                children.add(child);
                OutputStream out = session.write(child);
                try {
                    byte[] lineBytes = line.getBytes(StandardCharsets.UTF_8);
                    out.write(lineBytes);
                }
                finally {
                    if (out == null) continue;
                    out.close();
                }
            }
        }
        catch (Exception e) {
            throw new ProcessException((Throwable)e);
        }
        Iterator iterator = children.iterator();
        while (true) {
            if (!iterator.hasNext()) {
                session.transfer(children, REL_SUCCESS);
                return;
            }
            FlowFile child = (FlowFile)iterator.next();
            session.putAttribute(child, "num.lines", String.valueOf(children.size()));
        }
    }
}

