/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.tests.system;

import java.util.List;
import java.util.Set;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.state.Scope;
import org.apache.nifi.cs.tests.system.SetStateService;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;

public class SetState
extends AbstractProcessor {
    static final PropertyDescriptor STATE_SERVICE = new PropertyDescriptor.Builder().name("State Service").identifiesControllerService(SetStateService.class).required(true).build();
    static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").build();

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return List.of(STATE_SERVICE);
    }

    public Set<Relationship> getRelationships() {
        return Set.of(REL_SUCCESS);
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        SetStateService service = (SetStateService)context.getProperty(STATE_SERVICE).asControllerService(SetStateService.class);
        try {
            service.setState("local", "local", Scope.LOCAL);
            service.setState("cluster", "cluster", Scope.CLUSTER);
        }
        catch (Exception e) {
            throw new ProcessException((Throwable)e);
        }
        session.transfer(flowFile, REL_SUCCESS);
    }
}

