/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.tests.system;

import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;

public class ReplaceWithFile
extends AbstractProcessor {
    static final PropertyDescriptor FILENAME = new PropertyDescriptor.Builder().name("Filename").displayName("Filename").description("Fully qualified path to the file that should be ingested").required(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.NONE).build();
    static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").build();

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return Collections.singletonList(FILENAME);
    }

    public Set<Relationship> getRelationships() {
        return Collections.singleton(REL_SUCCESS);
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        String filename = context.getProperty(FILENAME).getValue();
        File file = new File(filename);
        if (!file.exists()) {
            this.getLogger().debug("File {} does not yet exist so will yield", new Object[]{file.getAbsolutePath()});
            context.yield();
            return;
        }
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        flowFile = session.importFrom(file.toPath(), true, flowFile);
        session.getProvenanceReporter().fetch(flowFile, file.toURI().toString());
        session.transfer(flowFile, REL_SUCCESS);
        this.getLogger().info("Successfully imported replacement file {}", new Object[]{file.getAbsolutePath()});
    }
}

