/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.tests.system;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;

public class EvaluatePropertiesWithDifferentELScopes
extends AbstractProcessor {
    static final PropertyDescriptor EVALUATE_FLOWFILE_CONTEXT = new PropertyDescriptor.Builder().name("FlowFile Context").description("The value of the property will be evaluated with FlowFile attributes").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
    static final PropertyDescriptor EVALUATE_VARIABLE_REGISTRY_CONTEXT = new PropertyDescriptor.Builder().name("Variable Registry Context").description("The value of the property will be evaluated with only with the Variable Registry").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).build();
    static final PropertyDescriptor EVALUATE_NO_EL_CONTEXT = new PropertyDescriptor.Builder().name("Expression Language Not Evaluated").description("The value of the property will be evaluated without evaluating Expression Language").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.NONE).build();
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").build();

    public Set<Relationship> getRelationships() {
        return Collections.singleton(REL_SUCCESS);
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return Arrays.asList(EVALUATE_FLOWFILE_CONTEXT, EVALUATE_VARIABLE_REGISTRY_CONTEXT, EVALUATE_NO_EL_CONTEXT);
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        Integer flowFileContext = context.getProperty(EVALUATE_FLOWFILE_CONTEXT).evaluateAttributeExpressions(flowFile).asInteger();
        Integer variableRegistryContext = context.getProperty(EVALUATE_VARIABLE_REGISTRY_CONTEXT).evaluateAttributeExpressions().asInteger();
        String noElContext = context.getProperty(EVALUATE_NO_EL_CONTEXT).getValue();
        if (flowFileContext != null) {
            session.adjustCounter("flowfile", (long)flowFileContext.intValue(), false);
        }
        if (variableRegistryContext != null) {
            session.adjustCounter("variable.registry", (long)variableRegistryContext.intValue(), false);
        }
        if (noElContext != null && noElContext.matches("[0-9]+")) {
            session.adjustCounter("no.el.evaluation", (long)Integer.parseInt(noElContext), false);
        }
        session.transfer(flowFile, REL_SUCCESS);
    }
}

