/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.tests.system;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.nifi.annotation.behavior.TriggerSerially;
import org.apache.nifi.annotation.behavior.TriggerWhenEmpty;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.bin.Bin;
import org.apache.nifi.processor.util.bin.BinFiles;
import org.apache.nifi.processor.util.bin.BinManager;
import org.apache.nifi.processor.util.bin.BinProcessingResult;

@TriggerSerially
@TriggerWhenEmpty
public class ConcatenateRangeOfFlowFiles
extends BinFiles {
    public static final Relationship REL_MERGED = new Relationship.Builder().name("merged").description("The FlowFile containing the merged content").build();

    public Set<Relationship> getRelationships() {
        HashSet<Relationship> relationships = new HashSet<Relationship>();
        relationships.add(REL_ORIGINAL);
        relationships.add(REL_FAILURE);
        relationships.add(REL_MERGED);
        return relationships;
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        ArrayList<PropertyDescriptor> descriptors = new ArrayList<PropertyDescriptor>();
        descriptors.add(MIN_ENTRIES);
        descriptors.add(MAX_ENTRIES);
        descriptors.add(MIN_SIZE);
        descriptors.add(MAX_SIZE);
        descriptors.add(MAX_BIN_AGE);
        descriptors.add(MAX_BIN_COUNT);
        return descriptors;
    }

    protected FlowFile preprocessFlowFile(ProcessContext context, ProcessSession session, FlowFile flowFile) {
        return flowFile;
    }

    protected String getGroupId(ProcessContext context, FlowFile flowFile, ProcessSession session) {
        return null;
    }

    protected void setUpBinManager(BinManager binManager, ProcessContext context) {
    }

    protected BinProcessingResult processBin(Bin bin, ProcessContext context) throws ProcessException {
        ProcessSession session = bin.getSession();
        List flowFiles = bin.getContents();
        FlowFile merged = session.create((Collection)flowFiles);
        merged = session.merge((Collection)flowFiles, merged);
        session.transfer(merged, REL_MERGED);
        this.getLogger().info("Concatenated {} FlowFiles into {}", new Object[]{flowFiles.size(), merged});
        BinProcessingResult binProcessingResult = new BinProcessingResult(true);
        binProcessingResult.setCommitted(false);
        return binProcessingResult;
    }
}

