/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.tests.system;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.DescribedValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;

public class TransferBatch
extends AbstractProcessor {
    static final AllowableValue ROUTE_TO_FAILURE = new AllowableValue("Route to Failure", "Route to Failure", "If there are not enough FlowFiles available to satisfy the batch size, whatever is available will be transferred to the 'failure' relationship");
    static final AllowableValue ROLLBACK = new AllowableValue("Rollback", "Rollback", "If there are not enough FlowFiles available to satisfy the batch size, no FlowFiles will be transferred");
    static final AllowableValue TRANSFER_AVAILABLE = new AllowableValue("Transfer Available", "Transfer Available", "If there are not enough FlowFiles available to satisfy the batch size, whatever is available will be transferred to the 'success' relationship");
    static final PropertyDescriptor BATCH_SIZE = new PropertyDescriptor.Builder().name("Batch Size").displayName("Batch Size").description("The number of FlowFiles to transfer at once.").required(true).addValidator(StandardValidators.POSITIVE_INTEGER_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.NONE).defaultValue("1").build();
    static final PropertyDescriptor INSUFFICIENT_BATCH_SIZE_STRATEGY = new PropertyDescriptor.Builder().name("Insufficient Batch Size Strategy").displayName("Insufficient Batch Size Strategy").description("Specifies how to handle the situation in which there are fewer FlowFiles available than the configured Batch Size").required(true).allowableValues(new DescribedValue[]{TRANSFER_AVAILABLE, ROUTE_TO_FAILURE, ROLLBACK}).defaultValue(TRANSFER_AVAILABLE.getValue()).build();
    static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").build();
    static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").build();

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return Arrays.asList(BATCH_SIZE, INSUFFICIENT_BATCH_SIZE_STRATEGY);
    }

    public Set<Relationship> getRelationships() {
        return new HashSet<Relationship>(Arrays.asList(REL_SUCCESS, REL_FAILURE));
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        int batchSize = context.getProperty(BATCH_SIZE).asInteger();
        List flowFiles = session.get(batchSize);
        if (flowFiles.size() < batchSize) {
            String batchSizeStrategy = context.getProperty(INSUFFICIENT_BATCH_SIZE_STRATEGY).getValue();
            if (batchSizeStrategy.equalsIgnoreCase(ROUTE_TO_FAILURE.getValue())) {
                session.transfer((Collection)flowFiles, REL_FAILURE);
            } else if (batchSizeStrategy.equalsIgnoreCase(TRANSFER_AVAILABLE.getValue())) {
                session.transfer((Collection)flowFiles, REL_SUCCESS);
            } else {
                session.rollback(false);
            }
        } else {
            session.transfer((Collection)flowFiles, REL_SUCCESS);
        }
    }
}

