/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.tests.system;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.nifi.annotation.behavior.PrimaryNodeOnly;
import org.apache.nifi.annotation.behavior.Stateful;
import org.apache.nifi.annotation.configuration.DefaultSchedule;
import org.apache.nifi.components.state.Scope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;

@PrimaryNodeOnly
@DefaultSchedule(period="10 mins")
@Stateful(scopes={Scope.CLUSTER}, description="Stores three counters in state", dropStateKeySupported=false)
public class MultiKeyStateNotDroppable
extends AbstractProcessor {
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").autoTerminateDefault(true).build();

    public Set<Relationship> getRelationships() {
        return Set.of(REL_SUCCESS);
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        Map currentState;
        try {
            currentState = session.getState(Scope.CLUSTER).toMap();
        }
        catch (IOException e) {
            throw new ProcessException((Throwable)e);
        }
        int a = Integer.parseInt(currentState.getOrDefault("a", "0")) + 1;
        int b = Integer.parseInt(currentState.getOrDefault("b", "0")) + 1;
        int c = Integer.parseInt(currentState.getOrDefault("c", "0")) + 1;
        HashMap<String, String> newState = new HashMap<String, String>();
        newState.put("a", String.valueOf(a));
        newState.put("b", String.valueOf(b));
        newState.put("c", String.valueOf(c));
        try {
            session.setState(newState, Scope.CLUSTER);
        }
        catch (IOException e) {
            throw new ProcessException((Throwable)e);
        }
        FlowFile flowFile = session.create();
        session.transfer(flowFile, REL_SUCCESS);
    }
}

