/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.tests.system;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.Validator;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;

public class SetAttribute
extends AbstractProcessor {
    public Relationship REL_SUCCESS = new Relationship.Builder().name("success").build();

    public Set<Relationship> getRelationships() {
        return Collections.singleton(this.REL_SUCCESS);
    }

    protected PropertyDescriptor getSupportedDynamicPropertyDescriptor(String propertyDescriptorName) {
        return new PropertyDescriptor.Builder().name(propertyDescriptorName).addValidator(Validator.VALID).build();
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        HashMap<String, String> attributes = new HashMap<String, String>();
        for (Map.Entry entry : context.getProperties().entrySet()) {
            String attributeName = ((PropertyDescriptor)entry.getKey()).getName();
            String attributeValue = (String)entry.getValue();
            attributes.put(attributeName, attributeValue);
        }
        FlowFile updated = session.putAllAttributes(flowFile, attributes);
        session.transfer(updated, this.REL_SUCCESS);
    }
}

