/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.tests.system;

import java.io.BufferedWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.annotation.behavior.RequiresInstanceClassLoading;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.resource.ResourceCardinality;
import org.apache.nifi.components.resource.ResourceType;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;

@RequiresInstanceClassLoading
public class DynamicallyModifyClasspath
extends AbstractProcessor {
    static final PropertyDescriptor URLS = new PropertyDescriptor.Builder().name("URLs to Load").description("URLs to load onto the classpath").required(false).dynamicallyModifiesClasspath(true).identifiesExternalResource(ResourceCardinality.MULTIPLE, ResourceType.URL, new ResourceType[]{ResourceType.FILE, ResourceType.DIRECTORY}).build();
    static final PropertyDescriptor CLASS_TO_LOAD = new PropertyDescriptor.Builder().name("Class to Load").description("The name of the Class to load").required(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    static final PropertyDescriptor SLEEP_DURATION = new PropertyDescriptor.Builder().name("Sleep Duration").description("Amount of time to sleep in the onTrigger method").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).defaultValue("0 sec").build();
    static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("FlowFiles are routed to this relationship if the specified class can be loaded").build();
    static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("FlowFiles are routed to this relationship if the specified class cannot be loaded").build();

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return Arrays.asList(URLS, CLASS_TO_LOAD, SLEEP_DURATION);
    }

    public Set<Relationship> getRelationships() {
        return new HashSet<Relationship>(Arrays.asList(REL_SUCCESS, REL_FAILURE));
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        long sleepMillis = context.getProperty(SLEEP_DURATION).evaluateAttributeExpressions(flowFile).asTimePeriod(TimeUnit.MILLISECONDS);
        if (sleepMillis > 0L) {
            this.getLogger().info("Sleeping for {} millis", new Object[]{sleepMillis});
            try {
                Thread.sleep(sleepMillis);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            this.getLogger().info("Finished sleeping");
        }
        String classToLoad = context.getProperty(CLASS_TO_LOAD).getValue();
        try {
            Class<?> clazz = Class.forName(classToLoad);
            try (OutputStream out = session.write(flowFile);
                 OutputStreamWriter streamWriter = new OutputStreamWriter(out);
                 BufferedWriter writer = new BufferedWriter(streamWriter);){
                writer.write(clazz.getName());
                writer.newLine();
                writer.write(clazz.getClassLoader().toString());
            }
            session.transfer(flowFile, REL_SUCCESS);
            this.getLogger().info("Transferred {} to success", new Object[]{flowFile});
        }
        catch (Exception e) {
            this.getLogger().error("Failed to update {}", new Object[]{flowFile, e});
            session.transfer(flowFile, REL_FAILURE);
            this.getLogger().info("Transferred {} to failure", new Object[]{flowFile});
        }
    }
}

