/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.tests.system;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;

public class RoundRobinFlowFiles
extends AbstractProcessor {
    private volatile List<Relationship> relationships = new ArrayList<Relationship>();
    private final AtomicLong counter = new AtomicLong(0L);
    static final PropertyDescriptor RELATIONSHIP_COUNT = new PropertyDescriptor.Builder().name("Number of Relationships").displayName("Number of Relationships").description("The number of Relationships").required(true).addValidator(StandardValidators.POSITIVE_INTEGER_VALIDATOR).build();

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return Collections.singletonList(RELATIONSHIP_COUNT);
    }

    public Set<Relationship> getRelationships() {
        return new HashSet<Relationship>(this.relationships);
    }

    public void onPropertyModified(PropertyDescriptor descriptor, String oldValue, String newValue) {
        ArrayList<Relationship> relationships = new ArrayList<Relationship>();
        for (int i = 1; i <= Integer.parseInt(newValue); ++i) {
            relationships.add(RoundRobinFlowFiles.createRelationship(i));
        }
        this.relationships = Collections.unmodifiableList(relationships);
    }

    private static Relationship createRelationship(int num) {
        return new Relationship.Builder().name(String.valueOf(num)).description("Where to route flowfiles for this relationship index").build();
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        long count = this.counter.getAndIncrement();
        long numRelationships = context.getProperty(RELATIONSHIP_COUNT).asLong();
        int relationshipIdx = (int)(count % numRelationships);
        Relationship relationship = this.relationships.get(relationshipIdx);
        session.transfer(flowFile, relationship);
    }
}

