/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.tests.system;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;

public class IngestFile
extends AbstractProcessor {
    private static final String COMMIT_SYNCHRONOUS = "synchronous";
    private static final String COMMIT_ASYNC = "asynchronous";
    static final PropertyDescriptor FILENAME = new PropertyDescriptor.Builder().name("Filename").displayName("Filename").description("Fully qualified path to the file that should be ingested").required(true).addValidator(StandardValidators.FILE_EXISTS_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.NONE).build();
    static final PropertyDescriptor COMMIT_MODE = new PropertyDescriptor.Builder().name("Commit Mode").displayName("Commit Mode").description("How to commit the process session").allowableValues(new String[]{"asynchronous", "synchronous"}).defaultValue("asynchronous").build();
    static final PropertyDescriptor DELETE_FILE = new PropertyDescriptor.Builder().name("Delete File").description("Whether or not the file should be deleted after successfully ingesting").allowableValues(new String[]{"true", "false"}).defaultValue("true").required(true).build();
    static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").build();

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return Arrays.asList(FILENAME, COMMIT_MODE, DELETE_FILE);
    }

    public Set<Relationship> getRelationships() {
        return Collections.singleton(REL_SUCCESS);
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        String filename = context.getProperty(FILENAME).getValue();
        File file = new File(filename);
        FlowFile flowFile = session.create();
        flowFile = session.importFrom(file.toPath(), true, flowFile);
        session.transfer(flowFile, REL_SUCCESS);
        session.getProvenanceReporter().receive(flowFile, file.toURI().toString());
        boolean deleteFile = context.getProperty(DELETE_FILE).asBoolean();
        String commitMode = context.getProperty(COMMIT_MODE).getValue();
        if (COMMIT_SYNCHRONOUS.equalsIgnoreCase(commitMode)) {
            session.commit();
            if (deleteFile) {
                this.cleanup(file);
            }
        } else {
            session.commitAsync(() -> {
                if (deleteFile) {
                    this.cleanup(file);
                }
            });
        }
    }

    private void cleanup(File file) {
        this.getLogger().info("Deleting {}", new Object[]{file.getAbsolutePath()});
        try {
            Files.delete(file.toPath());
        }
        catch (IOException e) {
            this.getLogger().error("Failed to delete file", (Throwable)e);
        }
    }
}

