/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.stateless.parameters;

import java.util.Arrays;
import java.util.List;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.stateless.parameter.AbstractParameterValueProvider;

public class ParameterValueProviderWithProperties
extends AbstractParameterValueProvider {
    static final PropertyDescriptor REQUIRED_PARAMETER = new PropertyDescriptor.Builder().name("Required").displayName("Required").description("A required parameter").required(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.NONE).build();
    static final PropertyDescriptor OPTIONAL_PARAMETER = new PropertyDescriptor.Builder().name("Optional").displayName("Optional").description("An optional parameter").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.NONE).build();

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return Arrays.asList(REQUIRED_PARAMETER, OPTIONAL_PARAMETER);
    }

    public String getParameterValue(String contextName, String parameterName) {
        return (String)this.getPropertyContext().getAllProperties().get(parameterName);
    }

    public boolean isParameterDefined(String contextName, String parameterName) {
        return this.getPropertyContext().getAllProperties().containsKey(parameterName);
    }
}

