/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.parameter.tests.system;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.parameter.AbstractParameterProvider;
import org.apache.nifi.parameter.Parameter;
import org.apache.nifi.parameter.ParameterGroup;
import org.apache.nifi.parameter.ParameterProvider;
import org.apache.nifi.processor.util.StandardValidators;

public class PropertiesParameterProvider
extends AbstractParameterProvider
implements ParameterProvider {
    private PropertyDescriptor PARAMETERS = new PropertyDescriptor.Builder().name("parameters").displayName("Parameters").description("Specifies parameters in a properties file format").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).required(false).build();

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return Collections.singletonList(this.PARAMETERS);
    }

    public List<ParameterGroup> fetchParameters(ConfigurationContext context) {
        List parameters = context.getProperty(this.PARAMETERS).isSet() ? this.fetchParametersFromProperties(context.getProperty(this.PARAMETERS).getValue()) : Collections.emptyList();
        return Arrays.asList(new ParameterGroup("Parameters", parameters));
    }

    private List<Parameter> fetchParametersFromProperties(String parametersPropertiesValue) {
        Properties parameters = new Properties();
        try {
            parameters.load(new ByteArrayInputStream(parametersPropertiesValue.getBytes(StandardCharsets.UTF_8)));
        }
        catch (IOException e) {
            throw new RuntimeException("Could not parse parameters as properties: " + parametersPropertiesValue);
        }
        return parameters.entrySet().stream().map(entry -> new Parameter.Builder().name(entry.getKey().toString()).value(entry.getValue().toString()).provided(Boolean.valueOf(true)).build()).collect(Collectors.toList());
    }
}

