/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cs.tests.system;

import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.cs.tests.system.CountService;
import org.apache.nifi.migration.PropertyConfiguration;
import org.apache.nifi.processor.util.StandardValidators;

public class MigratePropertiesCountService
extends AbstractControllerService
implements CountService {
    private static final String PREVIOUS_START_VALUE_PROPERTY_NAME = "start-value";
    private static final String PREVIOUS_COUNT_SERVICE_PROPERTY_NAME = "count-service";
    static final PropertyDescriptor START_VALUE = new PropertyDescriptor.Builder().name("Start Value").description("Initial value for counting").required(true).addValidator(StandardValidators.LONG_VALIDATOR).defaultValue("0").build();
    static final PropertyDescriptor COUNT_SERVICE = new PropertyDescriptor.Builder().name("Count Service").description("Count Service for testing Controller Service dependencies").required(false).identifiesControllerService(CountService.class).build();
    private static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS = List.of(START_VALUE, COUNT_SERVICE);
    private final AtomicLong counter = new AtomicLong();

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    public void migrateProperties(PropertyConfiguration propertyConfiguration) {
        propertyConfiguration.renameProperty(PREVIOUS_START_VALUE_PROPERTY_NAME, START_VALUE.getName());
        propertyConfiguration.renameProperty(PREVIOUS_COUNT_SERVICE_PROPERTY_NAME, COUNT_SERVICE.getName());
    }

    public long count() {
        return this.counter.getAndIncrement();
    }
}

