/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.stateless.session;

import org.apache.nifi.connectable.Connectable;
import org.apache.nifi.controller.repository.metrics.PerformanceTracker;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.ProcessSessionFactory;
import org.apache.nifi.provenance.ProvenanceEventRepository;
import org.apache.nifi.stateless.engine.ExecutionProgress;
import org.apache.nifi.stateless.engine.ProcessContextFactory;
import org.apache.nifi.stateless.repository.RepositoryContextFactory;
import org.apache.nifi.stateless.session.AsynchronousCommitTracker;
import org.apache.nifi.stateless.session.StatelessProcessSession;

public class StatelessProcessSessionFactory
implements ProcessSessionFactory {
    private final Connectable connectable;
    private final RepositoryContextFactory contextFactory;
    private final ProvenanceEventRepository provenanceEventRepository;
    private final ProcessContextFactory processContextFactory;
    private final ExecutionProgress executionProgress;
    private final boolean requireSynchronousCommits;
    private final AsynchronousCommitTracker commitTracker;
    private final PerformanceTracker performanceTracker;

    public StatelessProcessSessionFactory(Connectable connectable, RepositoryContextFactory contextFactory, ProvenanceEventRepository provenanceEventRepository, ProcessContextFactory processContextFactory, ExecutionProgress executionProgress, boolean requireSynchronousCommits, AsynchronousCommitTracker commitTracker, PerformanceTracker performanceTracker) {
        this.connectable = connectable;
        this.contextFactory = contextFactory;
        this.provenanceEventRepository = provenanceEventRepository;
        this.processContextFactory = processContextFactory;
        this.executionProgress = executionProgress;
        this.requireSynchronousCommits = requireSynchronousCommits;
        this.commitTracker = commitTracker;
        this.performanceTracker = performanceTracker;
    }

    public ProcessSession createSession() {
        StatelessProcessSession session = new StatelessProcessSession(this.connectable, this.contextFactory, this.provenanceEventRepository, this.processContextFactory, this.executionProgress, this.requireSynchronousCommits, this.commitTracker, this.performanceTracker);
        this.executionProgress.registerCreatedSession(session);
        return session;
    }
}

