/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.scheduling;

import org.apache.nifi.engine.FlowEngine;
import org.apache.nifi.stateless.engine.ProcessContextFactory;

public class StatelessProcessSchedulerInitializationContext {
    private final ProcessContextFactory processContextFactory;
    private final FlowEngine componentLifeCycleThreadPool;
    private final FlowEngine componentMonitoringThreadPool;
    private final FlowEngine frameworkTaskThreadPool;
    private final boolean manageThreadPools;

    private StatelessProcessSchedulerInitializationContext(Builder builder) {
        this.processContextFactory = builder.processContextFactory;
        this.componentLifeCycleThreadPool = builder.componentLifeCycleThreadPool;
        this.componentMonitoringThreadPool = builder.componentMonitoringThreadPool;
        this.frameworkTaskThreadPool = builder.frameworkTaskThreadPool;
        this.manageThreadPools = builder.manageThreadPools;
    }

    public ProcessContextFactory getProcessContextFactory() {
        return this.processContextFactory;
    }

    public FlowEngine getComponentLifeCycleThreadPool() {
        return this.componentLifeCycleThreadPool;
    }

    public FlowEngine getComponentMonitoringThreadPool() {
        return this.componentMonitoringThreadPool;
    }

    public FlowEngine getFrameworkTaskThreadPool() {
        return this.frameworkTaskThreadPool;
    }

    public boolean isManageThreadPools() {
        return this.manageThreadPools;
    }

    public static final class Builder {
        private ProcessContextFactory processContextFactory;
        private FlowEngine componentLifeCycleThreadPool;
        private FlowEngine componentMonitoringThreadPool;
        private FlowEngine frameworkTaskThreadPool;
        private boolean manageThreadPools;

        public Builder processContextFactory(ProcessContextFactory processContextFactory) {
            this.processContextFactory = processContextFactory;
            return this;
        }

        public Builder componentLifeCycleThreadPool(FlowEngine componentLifeCycleThreadPool) {
            this.componentLifeCycleThreadPool = componentLifeCycleThreadPool;
            return this;
        }

        public Builder componentMonitoringThreadPool(FlowEngine componentMonitoringThreadPool) {
            this.componentMonitoringThreadPool = componentMonitoringThreadPool;
            return this;
        }

        public Builder frameworkTaskThreadPool(FlowEngine frameworkTaskThreadPool) {
            this.frameworkTaskThreadPool = frameworkTaskThreadPool;
            return this;
        }

        public Builder manageThreadPools(boolean manageThreadPools) {
            this.manageThreadPools = manageThreadPools;
            return this;
        }

        public StatelessProcessSchedulerInitializationContext build() {
            return new StatelessProcessSchedulerInitializationContext(this);
        }
    }
}

