/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.queryrecord;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.serialization.RecordReader;
import org.apache.nifi.serialization.RecordReaderFactory;
import org.apache.nifi.serialization.record.DataType;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordField;
import org.apache.nifi.serialization.record.RecordFieldType;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.serialization.record.RecordSet;
import org.apache.nifi.serialization.record.type.ArrayDataType;
import org.apache.nifi.serialization.record.type.ChoiceDataType;
import org.apache.nifi.serialization.record.type.MapDataType;
import org.apache.nifi.sql.ArrayType;
import org.apache.nifi.sql.ColumnSchema;
import org.apache.nifi.sql.ColumnType;
import org.apache.nifi.sql.MapType;
import org.apache.nifi.sql.NiFiTableSchema;
import org.apache.nifi.sql.ResettableDataSource;
import org.apache.nifi.sql.RowStream;
import org.apache.nifi.sql.ScalarType;

public class RecordDataSource
implements ResettableDataSource {
    private final NiFiTableSchema tableSchema;
    private final ProcessSession session;
    private final FlowFile flowFile;
    private final RecordReaderFactory readerFactory;
    private final ComponentLog logger;

    public RecordDataSource(RecordSchema recordSchema, ProcessSession session, FlowFile flowFile, RecordReaderFactory recordReaderFactory, ComponentLog logger) {
        this.tableSchema = RecordDataSource.createTableSchema(recordSchema);
        this.session = session;
        this.flowFile = flowFile;
        this.readerFactory = recordReaderFactory;
        this.logger = logger;
    }

    public NiFiTableSchema getSchema() {
        return this.tableSchema;
    }

    public RowStream reset() throws IOException {
        RecordReader reader;
        InputStream in = this.session.read(this.flowFile);
        try {
            reader = this.readerFactory.createRecordReader(this.flowFile, in, this.logger);
        }
        catch (Exception e) {
            in.close();
            throw new IOException(e);
        }
        final RecordSet recordSet = reader.createRecordSet();
        return new RowStream(){

            public void close() throws IOException {
                reader.close();
            }

            public Object[] nextRow() throws IOException {
                Record record = recordSet.next();
                return record == null ? null : record.getValues();
            }
        };
    }

    public static NiFiTableSchema createTableSchema(RecordSchema recordSchema) {
        ArrayList<ColumnSchema> columns = new ArrayList<ColumnSchema>();
        for (RecordField field : recordSchema.getFields()) {
            String columnName = field.getFieldName();
            ColumnType columnType = RecordDataSource.getColumnType(field.getDataType());
            boolean nullable = field.isNullable();
            columns.add(new ColumnSchema(columnName, columnType, nullable));
        }
        return new NiFiTableSchema(columns);
    }

    public static ColumnType getColumnType(DataType fieldType) {
        return switch (fieldType.getFieldType()) {
            default -> throw new MatchException(null, null);
            case RecordFieldType.BOOLEAN -> ScalarType.BOOLEAN;
            case RecordFieldType.BYTE -> ScalarType.BYTE;
            case RecordFieldType.UUID -> ScalarType.UUID;
            case RecordFieldType.CHAR -> ScalarType.CHARACTER;
            case RecordFieldType.DATE -> ScalarType.DATE;
            case RecordFieldType.DOUBLE -> ScalarType.DOUBLE;
            case RecordFieldType.FLOAT -> ScalarType.FLOAT;
            case RecordFieldType.INT -> ScalarType.INTEGER;
            case RecordFieldType.SHORT -> ScalarType.SHORT;
            case RecordFieldType.TIME -> ScalarType.TIME;
            case RecordFieldType.TIMESTAMP -> ScalarType.TIMESTAMP;
            case RecordFieldType.LONG -> ScalarType.LONG;
            case RecordFieldType.STRING -> ScalarType.STRING;
            case RecordFieldType.ENUM -> ScalarType.OBJECT;
            case RecordFieldType.ARRAY -> new ArrayType(RecordDataSource.getColumnType(((ArrayDataType)fieldType).getElementType()));
            case RecordFieldType.RECORD -> new ScalarType(Record.class);
            case RecordFieldType.MAP -> {
                MapDataType mapDataType = (MapDataType)fieldType;
                yield new MapType((ColumnType)ScalarType.STRING, RecordDataSource.getColumnType(mapDataType.getValueType()));
            }
            case RecordFieldType.BIGINT -> ScalarType.BIGINT;
            case RecordFieldType.DECIMAL -> ScalarType.DECIMAL;
            case RecordFieldType.CHOICE -> RecordDataSource.getChoiceColumnType(fieldType);
        };
    }

    private static ColumnType getChoiceColumnType(DataType fieldType) {
        ChoiceDataType choiceDataType = (ChoiceDataType)fieldType;
        DataType widestDataType = (DataType)choiceDataType.getPossibleSubTypes().get(0);
        for (DataType possibleType : choiceDataType.getPossibleSubTypes()) {
            if (possibleType == widestDataType) continue;
            if (possibleType.getFieldType().isWiderThan(widestDataType.getFieldType())) {
                widestDataType = possibleType;
                continue;
            }
            if (widestDataType.getFieldType().isWiderThan(possibleType.getFieldType())) continue;
            widestDataType = null;
            break;
        }
        if (widestDataType != null) {
            return RecordDataSource.getColumnType(widestDataType);
        }
        boolean allNumeric = true;
        for (DataType possibleType : choiceDataType.getPossibleSubTypes()) {
            if (RecordDataSource.isNumeric(possibleType)) continue;
            allNumeric = false;
            break;
        }
        if (allNumeric) {
            return ScalarType.STRING;
        }
        return ScalarType.OBJECT;
    }

    private static boolean isNumeric(DataType dataType) {
        return switch (dataType.getFieldType()) {
            case RecordFieldType.BYTE, RecordFieldType.DOUBLE, RecordFieldType.FLOAT, RecordFieldType.INT, RecordFieldType.SHORT, RecordFieldType.LONG, RecordFieldType.BIGINT, RecordFieldType.DECIMAL -> true;
            default -> false;
        };
    }
}

