/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.enrichment;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processors.standard.enrichment.IndexCorrelatedJoinStrategy;
import org.apache.nifi.serialization.SimpleRecordSchema;
import org.apache.nifi.serialization.record.MapRecord;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordField;
import org.apache.nifi.serialization.record.RecordFieldType;
import org.apache.nifi.serialization.record.RecordSchema;

public class WrapperJoinStrategy
extends IndexCorrelatedJoinStrategy {
    private static final String ORIGINAL_FIELD_NAME = "original";
    private static final String ENRICHMENT_FIELD_NAME = "enrichment";

    public WrapperJoinStrategy(ComponentLog logger) {
        super(logger);
    }

    @Override
    protected Record combineRecords(Record originalRecord, Record enrichmentRecord, RecordSchema resultSchema) {
        if (originalRecord == null && enrichmentRecord == null) {
            return null;
        }
        HashMap<String, Record> values = new HashMap<String, Record>();
        values.put(ORIGINAL_FIELD_NAME, originalRecord);
        values.put(ENRICHMENT_FIELD_NAME, enrichmentRecord);
        MapRecord wrapped = new MapRecord(resultSchema, values);
        return wrapped;
    }

    @Override
    protected RecordSchema createResultSchema(Record firstOriginalRecord, Record firstEnrichmentRecord) {
        ArrayList<RecordField> fields = new ArrayList<RecordField>();
        if (firstOriginalRecord != null) {
            fields.add(new RecordField(ORIGINAL_FIELD_NAME, RecordFieldType.RECORD.getRecordDataType(firstOriginalRecord.getSchema())));
        }
        if (firstEnrichmentRecord != null) {
            fields.add(new RecordField(ENRICHMENT_FIELD_NAME, RecordFieldType.RECORD.getRecordDataType(firstEnrichmentRecord.getSchema())));
        }
        SimpleRecordSchema recordSetSchema = new SimpleRecordSchema(fields);
        return recordSetSchema;
    }
}

