/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.db;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processors.standard.db.ColumnDescription;
import org.apache.nifi.processors.standard.db.NameNormalizer;
import org.apache.nifi.processors.standard.db.TableNotFoundException;

public class TableSchema {
    private final List<String> requiredColumnNames;
    private final Set<String> primaryKeyColumnNames;
    private final Map<String, ColumnDescription> columns;
    private final String quotedIdentifierString;
    private final String catalogName;
    private final String schemaName;
    private final String tableName;

    public TableSchema(String catalogName, String schemaName, String tableName, List<ColumnDescription> columnDescriptions, boolean translateColumnNames, NameNormalizer normalizer, Set<String> primaryKeyColumnNames, String quotedIdentifierString) {
        this.catalogName = catalogName;
        this.schemaName = schemaName;
        this.tableName = tableName;
        this.columns = new LinkedHashMap<String, ColumnDescription>();
        this.primaryKeyColumnNames = primaryKeyColumnNames;
        this.quotedIdentifierString = quotedIdentifierString;
        this.requiredColumnNames = new ArrayList<String>();
        for (ColumnDescription desc : columnDescriptions) {
            String colName = TableSchema.normalizedName(desc.getColumnName(), translateColumnNames, normalizer);
            this.columns.put(colName, desc);
            if (!desc.isRequired()) continue;
            this.requiredColumnNames.add(desc.getColumnName());
        }
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public Map<String, ColumnDescription> getColumns() {
        return this.columns;
    }

    public List<ColumnDescription> getColumnsAsList() {
        return new ArrayList<ColumnDescription>(this.columns.values());
    }

    public List<String> getRequiredColumnNames() {
        return this.requiredColumnNames;
    }

    public Set<String> getPrimaryKeyColumnNames() {
        return this.primaryKeyColumnNames;
    }

    public String getQuotedIdentifierString() {
        return this.quotedIdentifierString;
    }

    public static TableSchema from(Connection conn, String catalog, String schema, String tableName, boolean translateColumnNames, NameNormalizer normalizer, String updateKeys, ComponentLog log) throws SQLException {
        DatabaseMetaData dmd = conn.getMetaData();
        try (ResultSet colrs = dmd.getColumns(catalog, schema, tableName, "%");){
            ArrayList<ColumnDescription> cols = new ArrayList<ColumnDescription>();
            while (colrs.next()) {
                ColumnDescription col = ColumnDescription.from(colrs);
                cols.add(col);
            }
            if (cols.isEmpty()) {
                try (ResultSet tblrs = dmd.getTables(catalog, schema, tableName, null);){
                    ArrayList<String> object = new ArrayList<String>();
                    if (catalog != null) {
                        object.add(catalog);
                    }
                    if (schema != null) {
                        object.add(schema);
                    }
                    if (tableName != null) {
                        object.add(tableName);
                    }
                    if (!tblrs.next()) {
                        throw new TableNotFoundException("Table " + String.join((CharSequence)".", object) + " not found, ensure the Catalog, Schema, and/or Table Names match those in the database exactly");
                    }
                    log.warn("Table " + String.join((CharSequence)".", object) + " found but no columns were found, if this is not expected then check the user permissions for getting table metadata from the database");
                }
            }
            HashSet<String> primaryKeyColumns = new HashSet<String>();
            if (updateKeys == null) {
                try (ResultSet resultSet = dmd.getPrimaryKeys(catalog, schema, tableName);){
                    while (resultSet.next()) {
                        String colName = resultSet.getString("COLUMN_NAME");
                        primaryKeyColumns.add(colName);
                    }
                }
            } else {
                for (String updateKey : updateKeys.split(",")) {
                    String colName = TableSchema.normalizedName(updateKey, translateColumnNames, normalizer);
                    primaryKeyColumns.add(colName);
                }
            }
            TableSchema tableSchema = new TableSchema(catalog, schema, tableName, cols, translateColumnNames, normalizer, primaryKeyColumns, dmd.getIdentifierQuoteString());
            return tableSchema;
        }
    }

    public static String normalizedName(String name, boolean translateNames, NameNormalizer normalizer) {
        if (translateNames && normalizer != null) {
            return normalizer.getNormalizedName(name).trim().toUpperCase();
        }
        return name;
    }

    public String toString() {
        return "TableSchema[columns=" + String.valueOf(this.columns.values()) + "]";
    }
}

