/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.SideEffectFree;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.resource.ResourceCardinality;
import org.apache.nifi.components.resource.ResourceType;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.util.file.monitor.LastModifiedMonitor;
import org.apache.nifi.util.file.monitor.SynchronousFileWatcher;
import org.apache.nifi.util.file.monitor.UpdateMonitor;

@SideEffectFree
@SupportsBatching
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@Tags(value={"scan", "attributes", "search", "lookup", "find", "text"})
@CapabilityDescription(value="Scans the specified attributes of FlowFiles, checking to see if any of their values are present within the specified dictionary of terms")
public class ScanAttribute
extends AbstractProcessor {
    public static final String MATCH_CRITERIA_ALL = "All Must Match";
    public static final String MATCH_CRITERIA_ANY = "At Least 1 Must Match";
    public static final PropertyDescriptor MATCHING_CRITERIA = new PropertyDescriptor.Builder().name("Match Criteria").description("If set to All Must Match, then FlowFiles will be routed to 'matched' only if all specified attributes' values are found in the dictionary. If set to At Least 1 Must Match, FlowFiles will be routed to 'matched' if any attribute specified is found in the dictionary").required(true).allowableValues(new String[]{"At Least 1 Must Match", "All Must Match"}).defaultValue("At Least 1 Must Match").build();
    public static final PropertyDescriptor ATTRIBUTE_PATTERN = new PropertyDescriptor.Builder().name("Attribute Pattern").description("Regular Expression that specifies the names of attributes whose values will be matched against the terms in the dictionary").required(true).addValidator(StandardValidators.REGULAR_EXPRESSION_VALIDATOR).defaultValue(".*").build();
    public static final PropertyDescriptor DICTIONARY_FILE = new PropertyDescriptor.Builder().name("Dictionary File").description("A new-line-delimited text file that includes the terms that should trigger a match. Empty lines are ignored.  The contents of the text file are loaded into memory when the processor is scheduled and reloaded when the contents are modified.").required(true).identifiesExternalResource(ResourceCardinality.SINGLE, ResourceType.FILE, new ResourceType[0]).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).build();
    public static final PropertyDescriptor DICTIONARY_FILTER = new PropertyDescriptor.Builder().name("Dictionary Filter Pattern").description("A Regular Expression that will be applied to each line in the dictionary file. If the regular expression does not match the line, the line will not be included in the list of terms to search for. If a Matching Group is specified, only the portion of the term that matches that Matching Group will be used instead of the entire term. If not specified, all terms in the dictionary will be used and each term will consist of the text of the entire line in the file").required(false).addValidator(StandardValidators.createRegexValidator((int)0, (int)1, (boolean)false)).build();
    private static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS = List.of(DICTIONARY_FILE, ATTRIBUTE_PATTERN, MATCHING_CRITERIA, DICTIONARY_FILTER);
    public static final Relationship REL_MATCHED = new Relationship.Builder().name("matched").description("FlowFiles whose attributes are found in the dictionary will be routed to this relationship").build();
    public static final Relationship REL_UNMATCHED = new Relationship.Builder().name("unmatched").description("FlowFiles whose attributes are not found in the dictionary will be routed to this relationship").build();
    private static final Set<Relationship> RELATIONSHIPS = Set.of(REL_MATCHED, REL_UNMATCHED);
    private volatile Pattern dictionaryFilterPattern = null;
    private volatile Pattern attributePattern = null;
    private volatile Set<String> dictionaryTerms = null;
    private volatile SynchronousFileWatcher fileWatcher = null;

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    public Set<Relationship> getRelationships() {
        return RELATIONSHIPS;
    }

    @OnScheduled
    public void onScheduled(ProcessContext context) throws IOException {
        String filterRegex = context.getProperty(DICTIONARY_FILTER).getValue();
        this.dictionaryFilterPattern = filterRegex == null ? null : Pattern.compile(filterRegex);
        String attributeRegex = context.getProperty(ATTRIBUTE_PATTERN).getValue();
        this.attributePattern = attributeRegex.equals(".*") ? null : Pattern.compile(attributeRegex);
        this.dictionaryTerms = this.createDictionary(context);
        this.fileWatcher = new SynchronousFileWatcher(Paths.get(context.getProperty(DICTIONARY_FILE).evaluateAttributeExpressions().getValue(), new String[0]), (UpdateMonitor)new LastModifiedMonitor(), 1000L);
    }

    private Set<String> createDictionary(ProcessContext context) throws IOException {
        HashSet<String> terms = new HashSet<String>();
        try (InputStream fis = context.getProperty(DICTIONARY_FILE).evaluateAttributeExpressions().asResource().read();
             BufferedReader reader = new BufferedReader(new InputStreamReader(fis));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.isBlank()) continue;
                String matchingTerm = line;
                if (this.dictionaryFilterPattern != null) {
                    Matcher matcher = this.dictionaryFilterPattern.matcher(line);
                    if (!matcher.matches()) continue;
                    matchingTerm = matcher.groupCount() == 1 ? matcher.group(1) : line;
                }
                terms.add(matchingTerm);
            }
        }
        return Set.copyOf(terms);
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        List flowFiles = session.get(50);
        if (flowFiles.isEmpty()) {
            return;
        }
        ComponentLog logger = this.getLogger();
        try {
            if (this.fileWatcher.checkAndReset()) {
                this.dictionaryTerms = this.createDictionary(context);
            }
        }
        catch (IOException e) {
            logger.error("Unable to reload dictionary due to {}", (Throwable)e);
        }
        boolean matchAll = context.getProperty(MATCHING_CRITERIA).getValue().equals(MATCH_CRITERIA_ALL);
        for (FlowFile flowFile : flowFiles) {
            boolean matched = matchAll ? this.allMatch(flowFile, this.attributePattern, this.dictionaryTerms) : this.anyMatch(flowFile, this.attributePattern, this.dictionaryTerms);
            Relationship relationship = matched ? REL_MATCHED : REL_UNMATCHED;
            session.getProvenanceReporter().route(flowFile, relationship);
            session.transfer(flowFile, relationship);
            logger.info("Transferred {} to {}", new Object[]{flowFile, relationship});
        }
    }

    private boolean allMatch(FlowFile flowFile, Pattern attributePattern, Set<String> dictionary) {
        for (Map.Entry entry : flowFile.getAttributes().entrySet()) {
            if (attributePattern != null && !attributePattern.matcher((CharSequence)entry.getKey()).matches() || dictionary.contains(entry.getValue())) continue;
            return false;
        }
        return true;
    }

    private boolean anyMatch(FlowFile flowFile, Pattern attributePattern, Set<String> dictionary) {
        for (Map.Entry entry : flowFile.getAttributes().entrySet()) {
            if (attributePattern != null && !attributePattern.matcher((CharSequence)entry.getKey()).matches() || !dictionary.contains(entry.getValue())) continue;
            return true;
        }
        return false;
    }
}

