/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.apache.nifi.annotation.behavior.DynamicProperty;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.SideEffectFree;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.documentation.UseCase;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.Validator;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processors.standard.AbstractRecordProcessor;
import org.apache.nifi.processors.standard.UpdateRecord;
import org.apache.nifi.record.path.RecordFieldRemover;
import org.apache.nifi.record.path.util.RecordPathCache;
import org.apache.nifi.record.path.validation.RecordPathValidator;
import org.apache.nifi.serialization.record.Record;

@SideEffectFree
@SupportsBatching
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@Tags(value={"update", "record", "generic", "schema", "json", "csv", "avro", "freeform", "text", "remove", "delete"})
@CapabilityDescription(value="Modifies the contents of a FlowFile that contains Record-oriented data (i.e. data that can be read via a RecordReader and written by a RecordWriter) by removing selected fields. This Processor requires that at least one user-defined Property be added. The name of the property is ignored by the processor, but could be a meaningful identifier for the user. The value of the property should indicate a RecordPath that determines the field to be removed. The processor executes the removal in the order in which these properties are added to the processor. Set the \"Record Writer\" to \"Inherit Record Schema\" in order to use the updated Record Schema modified when removing Fields.")
@WritesAttributes(value={@WritesAttribute(attribute="record.error.message", description="This attribute provides on failure the error message encountered by the Reader or Writer.")})
@DynamicProperty(name="A description of the field to remove", value="A RecordPath to the field to be removed.", description="Any field that matches the RecordPath set as the value will be removed.", expressionLanguageScope=ExpressionLanguageScope.FLOWFILE_ATTRIBUTES)
@SeeAlso(value={UpdateRecord.class})
@UseCase(description="Remove one or more fields from a Record, where the names of the fields to remove are known.", keywords={"record", "field", "drop", "remove", "delete", "expunge", "recordpath"}, configuration="Configure the Record Reader according to the incoming data format.\nConfigure the Record Writer according to the desired output format.\n\nFor each field that you want to remove, add a single new property to the Processor.\nThe name of the property can be anything but it's recommended to use a brief description of the field.\nThe value of the property is a RecordPath that matches the field to remove.\n\nFor example, to remove the `name` and `email` fields, add two Properties:\n`name` = `/name`\n`email` = `/email`\n")
public class RemoveRecordField
extends AbstractRecordProcessor {
    private volatile RecordPathCache recordPathCache;
    private static final String ROOT_PATH = "/";

    protected PropertyDescriptor getSupportedDynamicPropertyDescriptor(String propertyDescriptorName) {
        return new PropertyDescriptor.Builder().name(propertyDescriptorName).displayName(propertyDescriptorName).description("The RecordPath to the field that needs to be removed for " + propertyDescriptorName).required(false).dynamic(true).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator((Validator)new RecordPathValidator()).build();
    }

    protected Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        boolean containsDynamic = validationContext.getProperties().keySet().stream().anyMatch(PropertyDescriptor::isDynamic);
        if (containsDynamic) {
            ArrayList<ValidationResult> validationResults = new ArrayList<ValidationResult>(validationContext.getProperties().size());
            validationContext.getProperties().keySet().stream().filter(PropertyDescriptor::isDynamic).forEach(property -> {
                String path = validationContext.getProperty(property).evaluateAttributeExpressions().getValue();
                if (ROOT_PATH.equals(path)) {
                    validationResults.add(new ValidationResult.Builder().subject(property.getDisplayName()).valid(false).explanation("the root RecordPath cannot be removed").build());
                }
            });
            return validationResults;
        }
        return Set.of(new ValidationResult.Builder().subject("User-defined Properties").valid(false).explanation("at least one RecordPath must be specified").build());
    }

    @OnScheduled
    public void collectRecordPaths(ProcessContext context) {
        this.recordPathCache = new RecordPathCache(context.getProperties().size() * 2);
    }

    @Override
    protected Record process(Record record, FlowFile flowFile, ProcessContext context, long count) {
        ArrayList<RecordFieldRemover.RecordPathRemovalProperties> recordPathsToRemove = new ArrayList<RecordFieldRemover.RecordPathRemovalProperties>();
        for (PropertyDescriptor property : context.getProperties().keySet()) {
            if (!property.isDynamic()) continue;
            String recordPath = context.getProperty(property).evaluateAttributeExpressions(flowFile).getValue();
            if (ROOT_PATH.equals(recordPath)) {
                throw new ProcessException(String.format("The root Record Path %s cannot be removed for %s", ROOT_PATH, property.getDisplayName()));
            }
            recordPathsToRemove.add(new RecordFieldRemover.RecordPathRemovalProperties(recordPath));
        }
        RecordFieldRemover recordFieldRemover = new RecordFieldRemover(record, this.recordPathCache);
        recordPathsToRemove.forEach(arg_0 -> ((RecordFieldRemover)recordFieldRemover).remove(arg_0));
        return recordFieldRemover.getRecord();
    }
}

