/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.annotation.behavior.DynamicProperty;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.SideEffectFree;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.expression.AttributeExpression;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.lookup.LookupFailureException;
import org.apache.nifi.lookup.LookupService;
import org.apache.nifi.lookup.StringLookupService;
import org.apache.nifi.migration.PropertyConfiguration;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;

@SideEffectFree
@SupportsBatching
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@Tags(value={"lookup", "cache", "enrich", "join", "attributes", "Attribute Expression Language"})
@CapabilityDescription(value="Lookup attributes from a lookup service")
@DynamicProperty(name="The name of the attribute to add to the FlowFile", value="The name of the key or property to retrieve from the lookup service", expressionLanguageScope=ExpressionLanguageScope.FLOWFILE_ATTRIBUTES, description="Adds a FlowFile attribute specified by the dynamic property's key with the value found in the lookup service using the the dynamic property's value")
public class LookupAttribute
extends AbstractProcessor {
    public static final PropertyDescriptor LOOKUP_SERVICE = new PropertyDescriptor.Builder().name("Lookup Service").description("The lookup service to use for attribute lookups").identifiesControllerService(StringLookupService.class).required(true).build();
    public static final PropertyDescriptor INCLUDE_EMPTY_VALUES = new PropertyDescriptor.Builder().name("Include Empty Values").description("Include null or blank values for keys that are null or blank").addValidator(StandardValidators.BOOLEAN_VALIDATOR).allowableValues(new String[]{"true", "false"}).defaultValue("true").required(true).build();
    private static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS = List.of(LOOKUP_SERVICE, INCLUDE_EMPTY_VALUES);
    public static final Relationship REL_MATCHED = new Relationship.Builder().description("FlowFiles with matching lookups are routed to this relationship").name("matched").build();
    public static final Relationship REL_UNMATCHED = new Relationship.Builder().description("FlowFiles with missing lookups are routed to this relationship").name("unmatched").build();
    public static final Relationship REL_FAILURE = new Relationship.Builder().description("FlowFiles with failing lookups are routed to this relationship").name("failure").build();
    private static final Set<Relationship> RELATIONSHIPS = Set.of(REL_MATCHED, REL_UNMATCHED, REL_FAILURE);
    private Map<PropertyDescriptor, PropertyValue> dynamicProperties;

    protected Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        Set requiredKeys;
        ArrayList<ValidationResult> errors = new ArrayList<ValidationResult>(super.customValidate(validationContext));
        Set dynamicProperties = validationContext.getProperties().keySet().stream().filter(PropertyDescriptor::isDynamic).collect(Collectors.toSet());
        if (dynamicProperties.isEmpty()) {
            errors.add(new ValidationResult.Builder().subject("User-Defined Properties").valid(false).explanation("At least one user-defined property must be specified.").build());
        }
        if ((requiredKeys = ((LookupService)validationContext.getProperty(LOOKUP_SERVICE).asControllerService(LookupService.class)).getRequiredKeys()) == null || requiredKeys.size() != 1) {
            errors.add(new ValidationResult.Builder().subject(LOOKUP_SERVICE.getDisplayName()).valid(false).explanation("LookupAttribute requires a key-value lookup service supporting exactly one required key.").build());
        }
        return errors;
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    protected PropertyDescriptor getSupportedDynamicPropertyDescriptor(String propertyDescriptorName) {
        return new PropertyDescriptor.Builder().name(propertyDescriptorName).required(false).addValidator(StandardValidators.createAttributeExpressionLanguageValidator((AttributeExpression.ResultType)AttributeExpression.ResultType.STRING, (boolean)true)).addValidator(StandardValidators.ATTRIBUTE_KEY_PROPERTY_NAME_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).dynamic(true).build();
    }

    public Set<Relationship> getRelationships() {
        return RELATIONSHIPS;
    }

    @OnScheduled
    public void onScheduled(ProcessContext context) {
        HashMap<PropertyDescriptor, PropertyValue> dynamicProperties = new HashMap<PropertyDescriptor, PropertyValue>();
        for (Map.Entry e : context.getProperties().entrySet()) {
            PropertyDescriptor descriptor = (PropertyDescriptor)e.getKey();
            if (!descriptor.isDynamic()) continue;
            PropertyValue value = context.getProperty(descriptor);
            dynamicProperties.put(descriptor, value);
        }
        this.dynamicProperties = Map.copyOf(dynamicProperties);
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        ComponentLog logger = this.getLogger();
        LookupService lookupService = (LookupService)context.getProperty(LOOKUP_SERVICE).asControllerService(LookupService.class);
        boolean includeEmptyValues = context.getProperty(INCLUDE_EMPTY_VALUES).asBoolean();
        for (FlowFile flowFile : session.get(50)) {
            try {
                this.onTrigger(logger, lookupService, includeEmptyValues, flowFile, session);
            }
            catch (IOException e) {
                throw new ProcessException(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void migrateProperties(PropertyConfiguration config) {
        config.renameProperty("lookup-service", LOOKUP_SERVICE.getName());
        config.renameProperty("include-empty-values", INCLUDE_EMPTY_VALUES.getName());
    }

    private void onTrigger(ComponentLog logger, LookupService lookupService, boolean includeEmptyValues, FlowFile flowFile, ProcessSession session) throws ProcessException, IOException {
        HashMap<String, String> attributes = new HashMap<String, String>(flowFile.getAttributes());
        boolean matched = false;
        try {
            Set requiredKeys = lookupService.getRequiredKeys();
            if (requiredKeys == null || requiredKeys.size() != 1) {
                throw new ProcessException("LookupAttribute requires a key-value lookup service supporting exactly one required key, was: " + (requiredKeys == null ? "null" : String.valueOf(requiredKeys.size())));
            }
            String coordinateKey = (String)requiredKeys.iterator().next();
            for (Map.Entry<PropertyDescriptor, PropertyValue> e : this.dynamicProperties.entrySet()) {
                Optional attributeValue;
                PropertyValue lookupKeyExpression = e.getValue();
                String lookupKey = lookupKeyExpression.evaluateAttributeExpressions(flowFile).getValue();
                String attributeName = e.getKey().getName();
                matched = this.putAttribute(attributeName, attributeValue = lookupService.lookup(Collections.singletonMap(coordinateKey, lookupKey), flowFile.getAttributes()), attributes, includeEmptyValues, logger) || matched;
                if (matched || !logger.isDebugEnabled()) continue;
                logger.debug("No such value for key: {}", new Object[]{lookupKey});
            }
            flowFile = session.putAllAttributes(flowFile, attributes);
            session.transfer(flowFile, matched ? REL_MATCHED : REL_UNMATCHED);
        }
        catch (LookupFailureException e) {
            logger.error(e.getMessage(), (Throwable)e);
            session.transfer(flowFile, REL_FAILURE);
        }
    }

    private boolean putAttribute(String attributeName, Optional<String> attributeValue, Map<String, String> attributes, boolean includeEmptyValues, ComponentLog logger) {
        boolean matched = false;
        if (attributeValue.isPresent() && StringUtils.isNotBlank((CharSequence)attributeValue.get())) {
            attributes.put(attributeName, attributeValue.get());
            matched = true;
        } else if (includeEmptyValues) {
            attributes.put(attributeName, attributeValue.isPresent() ? "" : "null");
            matched = true;
        }
        return matched;
    }
}

