/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.SideEffectFree;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.util.StopWatch;

@SideEffectFree
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@SupportsBatching
@Tags(value={"text", "convert", "characterset", "character set"})
@CapabilityDescription(value="Converts a FlowFile's content from one character set to another")
public class ConvertCharacterSet
extends AbstractProcessor {
    public static final PropertyDescriptor INPUT_CHARSET = new PropertyDescriptor.Builder().name("Input Character Set").description("The name of the CharacterSet to expect for Input").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.CHARACTER_SET_VALIDATOR).required(true).build();
    public static final PropertyDescriptor OUTPUT_CHARSET = new PropertyDescriptor.Builder().name("Output Character Set").description("The name of the CharacterSet to convert to").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.CHARACTER_SET_VALIDATOR).required(true).build();
    private static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS = List.of(INPUT_CHARSET, OUTPUT_CHARSET);
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("").build();
    private final Set<Relationship> RELATIONSHIPS = Set.of(REL_SUCCESS);
    public static final int MAX_BUFFER_SIZE = 524288;

    public Set<Relationship> getRelationships() {
        return this.RELATIONSHIPS;
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    public void onTrigger(ProcessContext context, ProcessSession session) {
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        ComponentLog logger = this.getLogger();
        Charset inputCharset = Charset.forName(context.getProperty(INPUT_CHARSET).evaluateAttributeExpressions(flowFile).getValue());
        Charset outputCharset = Charset.forName(context.getProperty(OUTPUT_CHARSET).evaluateAttributeExpressions(flowFile).getValue());
        CharBuffer charBuffer = CharBuffer.allocate(524288);
        CharsetDecoder decoder = inputCharset.newDecoder();
        decoder.onMalformedInput(CodingErrorAction.REPLACE);
        decoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
        decoder.replaceWith("?");
        CharsetEncoder encoder = outputCharset.newEncoder();
        encoder.onMalformedInput(CodingErrorAction.REPLACE);
        encoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
        encoder.replaceWith("?".getBytes(outputCharset));
        try {
            StopWatch stopWatch = new StopWatch(true);
            flowFile = session.write(flowFile, (rawIn, rawOut) -> {
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(rawIn, decoder), 524288);
                     BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(rawOut, encoder), 524288);){
                    int charsRead;
                    while ((charsRead = reader.read(charBuffer)) != -1) {
                        charBuffer.flip();
                        writer.write(charBuffer.array(), 0, charsRead);
                    }
                    writer.flush();
                }
            });
            session.getProvenanceReporter().modifyContent(flowFile, stopWatch.getElapsed(TimeUnit.MILLISECONDS));
            logger.info("successfully converted characters from {} to {} for {}", new Object[]{inputCharset, outputCharset, flowFile});
            session.transfer(flowFile, REL_SUCCESS);
        }
        catch (Exception e) {
            throw new ProcessException((Throwable)e);
        }
    }
}

