/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.ssh;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.PublicKey;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.processor.util.file.transfer.FileTransfer;
import org.apache.nifi.processors.standard.socket.ClientAuthenticationException;
import org.apache.nifi.processors.standard.socket.ClientConnectException;
import org.apache.nifi.processors.standard.ssh.SshClientProvider;
import org.apache.nifi.processors.standard.ssh.netty.StandardNettyIoServiceFactoryFactory;
import org.apache.nifi.processors.standard.util.SFTPTransfer;
import org.apache.nifi.proxy.ProxyConfiguration;
import org.apache.nifi.proxy.ProxyConfigurationService;
import org.apache.sshd.client.ClientBuilder;
import org.apache.sshd.client.SshClient;
import org.apache.sshd.client.future.ConnectFuture;
import org.apache.sshd.client.keyverifier.DefaultKnownHostsServerKeyVerifier;
import org.apache.sshd.client.keyverifier.KnownHostsServerKeyVerifier;
import org.apache.sshd.client.keyverifier.RejectAllServerKeyVerifier;
import org.apache.sshd.client.keyverifier.ServerKeyVerifier;
import org.apache.sshd.client.keyverifier.StaticServerKeyVerifier;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.compression.BuiltinCompressions;
import org.apache.sshd.common.compression.Compression;
import org.apache.sshd.common.config.keys.FilePasswordProvider;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.io.IoServiceFactoryFactory;
import org.apache.sshd.common.kex.BuiltinDHFactories;
import org.apache.sshd.common.keyprovider.FileKeyPairProvider;
import org.apache.sshd.common.keyprovider.KeyIdentityProvider;
import org.apache.sshd.core.CoreModuleProperties;

public class StandardSshClientProvider
implements SshClientProvider {
    private static final Duration HEARTBEAT_INTERVAL = Duration.ofSeconds(5L);
    private static final int HEARTBEAT_NO_REPLY_MAX = 5;
    private static final ServerKeyVerifier ACCEPT_ALL_SERVER_KEY_VERIFIER = new AcceptAllServerKeyVerifier();
    private static final List<NamedFactory<Compression>> COMPRESSION_FACTORIES = List.of(BuiltinCompressions.zlib, BuiltinCompressions.delayedZlib);

    @Override
    public ClientSession getClientSession(PropertyContext context, Map<String, String> attributes) {
        boolean keepAliveEnabled;
        Objects.requireNonNull(context, "Property Context required");
        Objects.requireNonNull(attributes, "Attributes required");
        SshClient sshClient = this.buildSshClient(context);
        boolean compressionEnabled = context.getProperty(FileTransfer.USE_COMPRESSION).asBoolean();
        if (compressionEnabled) {
            sshClient.setCompressionFactories(COMPRESSION_FACTORIES);
        }
        if (keepAliveEnabled = context.getProperty(SFTPTransfer.USE_KEEPALIVE_ON_TIMEOUT).asBoolean().booleanValue()) {
            CoreModuleProperties.HEARTBEAT_INTERVAL.set((PropertyResolver)sshClient, (Object)HEARTBEAT_INTERVAL);
            CoreModuleProperties.HEARTBEAT_NO_REPLY_MAX.set((PropertyResolver)sshClient, (Object)5);
        }
        this.setAlgorithmConfiguration(context, sshClient);
        this.setProxy(context, attributes, sshClient);
        this.setAuthentication(context, attributes, sshClient);
        sshClient.start();
        try {
            return this.getAuthenticatedClientSession(context, attributes, sshClient);
        }
        catch (Exception e) {
            sshClient.stop();
            throw e;
        }
    }

    private ClientSession getAuthenticatedClientSession(PropertyContext context, Map<String, String> attributes, SshClient sshClient) {
        ClientSession clientSession;
        String username = context.getProperty(FileTransfer.USERNAME).evaluateAttributeExpressions(attributes).getValue();
        Duration connectionTimeout = context.getProperty(FileTransfer.CONNECTION_TIMEOUT).asDuration();
        String hostname = context.getProperty(FileTransfer.HOSTNAME).evaluateAttributeExpressions(attributes).getValue();
        int port = context.getProperty(SFTPTransfer.PORT).evaluateAttributeExpressions(attributes).asInteger();
        try {
            ConnectFuture connectFuture = (ConnectFuture)sshClient.connect(username, hostname, port).verify(connectionTimeout);
            clientSession = connectFuture.getClientSession();
        }
        catch (IOException e) {
            throw new ClientConnectException("SSH Connection failed [%s:%d]".formatted(hostname, port), e);
        }
        try {
            clientSession.auth().verify(connectionTimeout);
        }
        catch (IOException e) {
            throw new ClientAuthenticationException("SSH Authentication failed [%s:%d]".formatted(hostname, port), e);
        }
        clientSession.addCloseFutureListener(closeFuture -> sshClient.stop());
        return clientSession;
    }

    private SshClient buildSshClient(PropertyContext context) {
        String keyExchangeAlgorithmsAllowed;
        ClientBuilder clientBuilder = ClientBuilder.builder();
        this.setHostKeyChecking(context, clientBuilder);
        SFTPTransfer.AlgorithmConfiguration algorithmConfiguration = (SFTPTransfer.AlgorithmConfiguration)context.getProperty(SFTPTransfer.ALGORITHM_CONFIGURATION).asAllowableValue(SFTPTransfer.AlgorithmConfiguration.class);
        if (SFTPTransfer.AlgorithmConfiguration.CUSTOM == algorithmConfiguration && StringUtils.isNotBlank((CharSequence)(keyExchangeAlgorithmsAllowed = context.getProperty(SFTPTransfer.KEY_EXCHANGE_ALGORITHMS_ALLOWED).evaluateAttributeExpressions().getValue()))) {
            BuiltinDHFactories.ParseResult result = BuiltinDHFactories.parseDHFactoriesList((String)keyExchangeAlgorithmsAllowed);
            List parsedFactories = result.getParsedFactories();
            List keyExchangeFactories = NamedFactory.setUpTransformedFactories((boolean)false, (Collection)parsedFactories, (Function)ClientBuilder.DH2KEX);
            clientBuilder.keyExchangeFactories(keyExchangeFactories);
        }
        return clientBuilder.build(true);
    }

    private void setHostKeyChecking(PropertyContext context, ClientBuilder clientBuilder) {
        boolean strictHostKeyChecking = context.getProperty(SFTPTransfer.STRICT_HOST_KEY_CHECKING).asBoolean();
        if (strictHostKeyChecking) {
            String hostKeyFilePath = context.getProperty(SFTPTransfer.HOST_KEY_FILE).getValue();
            if (hostKeyFilePath == null || hostKeyFilePath.isEmpty()) {
                clientBuilder.serverKeyVerifier((ServerKeyVerifier)new DefaultKnownHostsServerKeyVerifier((ServerKeyVerifier)RejectAllServerKeyVerifier.INSTANCE));
            } else {
                Path hostKeyFile = Paths.get(hostKeyFilePath, new String[0]);
                clientBuilder.serverKeyVerifier((ServerKeyVerifier)new KnownHostsServerKeyVerifier((ServerKeyVerifier)RejectAllServerKeyVerifier.INSTANCE, hostKeyFile));
            }
        } else {
            clientBuilder.serverKeyVerifier(ACCEPT_ALL_SERVER_KEY_VERIFIER);
        }
    }

    private void setAlgorithmConfiguration(PropertyContext context, SshClient sshClient) {
        SFTPTransfer.AlgorithmConfiguration algorithmConfiguration = (SFTPTransfer.AlgorithmConfiguration)context.getProperty(SFTPTransfer.ALGORITHM_CONFIGURATION).asAllowableValue(SFTPTransfer.AlgorithmConfiguration.class);
        if (SFTPTransfer.AlgorithmConfiguration.CUSTOM == algorithmConfiguration) {
            String macAlgorithmsAllowed;
            String keyAlgorithmsAllowed;
            String ciphersAllowed = context.getProperty(SFTPTransfer.CIPHERS_ALLOWED).evaluateAttributeExpressions().getValue();
            if (StringUtils.isNotBlank((CharSequence)ciphersAllowed)) {
                sshClient.setCipherFactoriesNameList(ciphersAllowed);
            }
            if (StringUtils.isNotBlank((CharSequence)(keyAlgorithmsAllowed = context.getProperty(SFTPTransfer.KEY_ALGORITHMS_ALLOWED).evaluateAttributeExpressions().getValue()))) {
                sshClient.setSignatureFactoriesNameList(keyAlgorithmsAllowed);
            }
            if (StringUtils.isNotBlank((CharSequence)(macAlgorithmsAllowed = context.getProperty(SFTPTransfer.MESSAGE_AUTHENTICATION_CODES_ALLOWED).evaluateAttributeExpressions().getValue()))) {
                sshClient.setMacFactoriesNameList(macAlgorithmsAllowed);
            }
        }
    }

    private void setProxy(PropertyContext context, Map<String, String> attributes, SshClient sshClient) {
        ProxyConfiguration proxyConfiguration;
        PropertyValue proxyConfigurationServiceProperty = context.getProperty(SFTPTransfer.PROXY_CONFIGURATION_SERVICE);
        if (proxyConfigurationServiceProperty.isSet()) {
            ProxyConfigurationService proxyConfigurationService = (ProxyConfigurationService)proxyConfigurationServiceProperty.asControllerService(ProxyConfigurationService.class);
            proxyConfiguration = proxyConfigurationService.getConfiguration();
        } else {
            proxyConfiguration = new ProxyConfiguration();
        }
        String hostname = context.getProperty(FileTransfer.HOSTNAME).evaluateAttributeExpressions(attributes).getValue();
        int port = context.getProperty(SFTPTransfer.PORT).evaluateAttributeExpressions(attributes).asInteger();
        InetSocketAddress remoteAddress = new InetSocketAddress(hostname, port);
        Duration socketTimeout = context.getProperty(SFTPTransfer.DATA_TIMEOUT).asDuration();
        StandardNettyIoServiceFactoryFactory ioServiceFactoryFactory = new StandardNettyIoServiceFactoryFactory(remoteAddress, proxyConfiguration, socketTimeout);
        sshClient.setIoServiceFactoryFactory((IoServiceFactoryFactory)ioServiceFactoryFactory);
    }

    private void setAuthentication(PropertyContext context, Map<String, String> attributes, SshClient sshClient) {
        String privateKeyPath;
        String password = context.getProperty(FileTransfer.PASSWORD).evaluateAttributeExpressions(attributes).getValue();
        if (password != null) {
            sshClient.addPasswordIdentity(password);
        }
        if ((privateKeyPath = context.getProperty(SFTPTransfer.PRIVATE_KEY_PATH).evaluateAttributeExpressions(attributes).getValue()) != null) {
            Path privateKeyFilePath = Paths.get(privateKeyPath, new String[0]);
            FileKeyPairProvider fileKeyPairProvider = new FileKeyPairProvider();
            fileKeyPairProvider.setPaths(List.of(privateKeyFilePath));
            String privateKeyPassphrase = context.getProperty(SFTPTransfer.PRIVATE_KEY_PASSPHRASE).evaluateAttributeExpressions(attributes).getValue();
            if (privateKeyPassphrase != null) {
                FilePasswordProvider filePasswordProvider = FilePasswordProvider.of((String)privateKeyPassphrase);
                fileKeyPairProvider.setPasswordFinder(filePasswordProvider);
            }
            sshClient.setKeyIdentityProvider((KeyIdentityProvider)fileKeyPairProvider);
        }
    }

    protected static class AcceptAllServerKeyVerifier
    extends StaticServerKeyVerifier {
        protected AcceptAllServerKeyVerifier() {
            super(true);
        }

        protected void handleAcceptance(ClientSession sshClientSession, SocketAddress remoteAddress, PublicKey serverKey) {
            if (this.log.isInfoEnabled()) {
                String algorithm = serverKey == null ? null : serverKey.getAlgorithm();
                String fingerprint = KeyUtils.getFingerPrint((PublicKey)serverKey);
                this.log.info("Accepted unverified server {} [{}] Key {}", new Object[]{remoteAddress, algorithm, fingerprint});
            }
        }
    }
}

