/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.db.impl;

import java.sql.JDBCType;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.processors.standard.db.ColumnDescription;
import org.apache.nifi.processors.standard.db.DatabaseAdapter;
import org.apache.nifi.processors.standard.db.TableSchema;

public class OracleDatabaseAdapter
implements DatabaseAdapter {
    @Override
    public String getName() {
        return "Oracle";
    }

    @Override
    public String getDescription() {
        return "Generates Oracle compliant SQL";
    }

    @Override
    public String getSelectStatement(String tableName, String columnNames, String whereClause, String orderByClause, Long limit, Long offset) {
        return this.getSelectStatement(tableName, columnNames, whereClause, orderByClause, limit, offset, null);
    }

    @Override
    public String getSelectStatement(String tableName, String columnNames, String whereClause, String orderByClause, Long limit, Long offset, String columnForPartitioning) {
        boolean nestedSelect;
        if (StringUtils.isEmpty((CharSequence)tableName)) {
            throw new IllegalArgumentException("Table name cannot be null or empty");
        }
        StringBuilder query = new StringBuilder();
        boolean bl = nestedSelect = (limit != null || offset != null) && StringUtils.isEmpty((CharSequence)columnForPartitioning);
        if (nestedSelect) {
            query.append("SELECT ");
            if (StringUtils.isEmpty((CharSequence)columnNames) || columnNames.trim().equals("*")) {
                query.append("*");
            } else {
                query.append(columnNames);
            }
            query.append(" FROM (SELECT a.*, ROWNUM rnum FROM (");
        }
        query.append("SELECT ");
        if (StringUtils.isEmpty((CharSequence)columnNames) || columnNames.trim().equals("*")) {
            query.append("*");
        } else {
            query.append(columnNames);
        }
        query.append(" FROM ");
        query.append(tableName);
        if (!StringUtils.isEmpty((CharSequence)whereClause)) {
            query.append(" WHERE ");
            query.append(whereClause);
            if (!StringUtils.isEmpty((CharSequence)columnForPartitioning)) {
                query.append(" AND ");
                query.append(columnForPartitioning);
                query.append(" >= ");
                query.append(offset != null ? offset : "0");
                if (limit != null) {
                    query.append(" AND ");
                    query.append(columnForPartitioning);
                    query.append(" < ");
                    query.append((offset == null ? 0L : offset) + limit);
                }
            }
        }
        if (!StringUtils.isEmpty((CharSequence)orderByClause) && StringUtils.isEmpty((CharSequence)columnForPartitioning)) {
            query.append(" ORDER BY ");
            query.append(orderByClause);
        }
        if (nestedSelect) {
            query.append(") a");
            long offsetVal = 0L;
            if (offset != null) {
                offsetVal = offset;
            }
            if (limit != null) {
                query.append(" WHERE ROWNUM <= ");
                query.append(offsetVal + limit);
            }
            query.append(") WHERE rnum > ");
            query.append(offsetVal);
        }
        return query.toString();
    }

    @Override
    public String getTableAliasClause(String tableName) {
        return tableName;
    }

    @Override
    public String getAlterTableStatement(String tableName, List<ColumnDescription> columnsToAdd) {
        StringBuilder createTableStatement = new StringBuilder();
        ArrayList<String> columnsAndDatatypes = new ArrayList<String>(columnsToAdd.size());
        for (ColumnDescription column : columnsToAdd) {
            String dataType = this.getSQLForDataType(column.getDataType());
            StringBuilder sb = new StringBuilder().append(column.getColumnName()).append(" ").append(dataType);
            columnsAndDatatypes.add(sb.toString());
        }
        createTableStatement.append("ALTER TABLE ").append(tableName).append(" ADD (").append(String.join((CharSequence)", ", columnsAndDatatypes)).append(") ");
        return createTableStatement.toString();
    }

    @Override
    public String getSQLForDataType(int sqlType) {
        return switch (sqlType) {
            case 8 -> "DOUBLE PRECISION";
            case -16, -15, -9, -1, 1, 12, 1111, 2005, 2009, 2011 -> "VARCHAR2(2000)";
            default -> JDBCType.valueOf(sqlType).getName();
        };
    }

    @Override
    public boolean supportsCreateTableIfNotExists() {
        return true;
    }

    @Override
    public String getCreateTableStatement(TableSchema tableSchema) {
        StringBuilder createTableStatement = new StringBuilder().append("DECLARE\n\tsql_stmt long;\nBEGIN\n\tsql_stmt:='CREATE TABLE ").append(this.generateTableName(tableSchema.getCatalogName(), tableSchema.getSchemaName(), tableSchema.getTableName(), tableSchema)).append(" (");
        List<ColumnDescription> columns = tableSchema.getColumnsAsList();
        Set<String> primaryKeyColumnNames = tableSchema.getPrimaryKeyColumnNames();
        for (int i = 0; i < columns.size(); ++i) {
            ColumnDescription column = columns.get(i);
            createTableStatement.append(i != 0 ? ", " : "").append(column.getColumnName()).append(" ").append(this.getSQLForDataType(column.getDataType())).append(column.isNullable() ? "" : " NOT NULL").append(primaryKeyColumnNames != null && primaryKeyColumnNames.contains(column.getColumnName()) ? " PRIMARY KEY" : "");
        }
        createTableStatement.append(")';\nEXECUTE IMMEDIATE sql_stmt;\nEXCEPTION\n\tWHEN OTHERS THEN\n\t\tIF SQLCODE = -955 THEN\n\t\t\t").append("NULL;\n\t\tELSE\n\t\t\tRAISE;\n\t\tEND IF;\nEND;");
        return createTableStatement.toString();
    }
}

