/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.http;

import java.util.Set;
import org.apache.nifi.components.DescribedValue;
import org.apache.nifi.jetty.configuration.connector.ApplicationLayerProtocol;

public enum HttpProtocolStrategy implements DescribedValue
{
    HTTP_1_1("http/1.1", "HTTP/1.1", Set.of(ApplicationLayerProtocol.HTTP_1_1)),
    H2_HTTP_1_1("h2 http/1.1", "HTTP/2 and HTTP/1.1 negotiated based on requested protocols", Set.of(ApplicationLayerProtocol.HTTP_1_1, ApplicationLayerProtocol.H2)),
    H2("h2", "HTTP/2", Set.of(ApplicationLayerProtocol.H2));

    private final String displayName;
    private final String description;
    private final Set<ApplicationLayerProtocol> applicationLayerProtocols;

    private HttpProtocolStrategy(String displayName, String description, Set<ApplicationLayerProtocol> applicationLayerProtocols) {
        this.displayName = displayName;
        this.description = description;
        this.applicationLayerProtocols = applicationLayerProtocols;
    }

    public String getValue() {
        return this.name();
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public Set<ApplicationLayerProtocol> getApplicationLayerProtocols() {
        return this.applicationLayerProtocols;
    }
}

