/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.ftp.commands;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.ftpserver.command.AbstractCommand;
import org.apache.ftpserver.ftplet.DefaultFtpReply;
import org.apache.ftpserver.ftplet.FtpRequest;
import org.apache.ftpserver.impl.FtpIoSession;
import org.apache.ftpserver.impl.FtpServerContext;

public class FtpCommandHELP
extends AbstractCommand {
    private static final Map<String, String> COMMAND_SPECIFIC_HELP = Map.ofEntries(Map.entry("ABOR", "Syntax: ABOR"), Map.entry("APPE", "Syntax: APPE <sp> <pathname>"), Map.entry("AUTH", "Syntax: AUTH <sp> <security_mechanism>"), Map.entry("CDUP", "Syntax: CDUP"), Map.entry("CWD", "Syntax: CWD <sp> <pathname>"), Map.entry("DELE", "Syntax: DELE <sp> <pathname>"), Map.entry("EPRT", "Syntax: EPRT<space><d><net-prt><d><net-addr><d><tcp-port><d>"), Map.entry("EPSV", "Syntax: EPSV"), Map.entry("FEAT", "Syntax: FEAT"), Map.entry("HELP", "Syntax: HELP [<sp> <string>]"), Map.entry("LIST", "Syntax: LIST [<sp> <pathname>]"), Map.entry("MDTM", "Syntax: MDTM <sp> <pathname>"), Map.entry("MKD", "Syntax: MKD <sp> <pathname>"), Map.entry("MLSD", "Syntax: MLSD [<sp> <pathname>]"), Map.entry("MLST", "Syntax: MLST [<sp> <pathname>]"), Map.entry("MODE", "Syntax: MODE <sp> <mode-code>"), Map.entry("NLST", "Syntax: NLST [<sp> <pathname>]"), Map.entry("NOOP", "Syntax: NOOP"), Map.entry("OPTS", "Syntax: OPTS <sp> <options>"), Map.entry("PASS", "Syntax: PASS <sp> <password>"), Map.entry("PASV", "Syntax: PASV"), Map.entry("PBSZ", "Syntax: PBSZ <sp> <buffer_size>"), Map.entry("PORT", "Syntax: PORT <sp> <host-port>"), Map.entry("PROT", "Syntax: PROT <sp> <protection_level>"), Map.entry("PWD", "Syntax: PWD"), Map.entry("QUIT", "Syntax: QUIT"), Map.entry("REIN", "Syntax: REIN"), Map.entry("REST", "Syntax: REST <sp> <marker>"), Map.entry("RETR", "Syntax: RETR <sp> <pathname>"), Map.entry("RMD", "Syntax: RMD <sp> <pathname>"), Map.entry("RNFR", "Syntax: RNFR <sp> <pathname>"), Map.entry("RNTO", "Syntax: RNTO <sp> <pathname>"), Map.entry("SITE", "Syntax: SITE <sp> <string>"), Map.entry("SIZE", "Syntax: SIZE <sp> <pathname>"), Map.entry("STAT", "Syntax: STAT [<sp> <pathname>]"), Map.entry("STOR", "Syntax: STOR <sp> <pathname>"), Map.entry("STOU", "Syntax: STOU"), Map.entry("SYST", "Syntax: SYST"), Map.entry("TYPE", "Syntax: TYPE <sp> <type-code>"), Map.entry("USER", "Syntax: USER <sp> <username>"));
    private static final int MAX_NUMBER_OF_COMMANDS_IN_A_ROW = 5;
    private final Set<String> availableCommands = new TreeSet<String>();

    public void addCommand(String command) {
        if (!command.startsWith("SITE_")) {
            this.availableCommands.add(command);
        }
    }

    public void execute(FtpIoSession session, FtpServerContext context, FtpRequest request) {
        session.resetState();
        if (!request.hasArgument()) {
            this.sendDefaultHelpMessage(session);
        } else {
            this.handleRequestWithArgument(session, request);
        }
    }

    private void sendDefaultHelpMessage(FtpIoSession session) {
        this.sendCustomHelpMessage(session, this.getDefaultHelpMessage());
    }

    private String getDefaultHelpMessage() {
        StringBuilder helpMessage = new StringBuilder("The following commands are supported.\n");
        int currentNumberOfCommandsInARow = 0;
        Iterator<String> iterator = this.availableCommands.iterator();
        while (iterator.hasNext()) {
            String command = iterator.next();
            if (currentNumberOfCommandsInARow == 5) {
                helpMessage.append("\n");
                currentNumberOfCommandsInARow = 0;
            }
            if (iterator.hasNext()) {
                helpMessage.append(command).append(", ");
            } else {
                helpMessage.append(command);
            }
            ++currentNumberOfCommandsInARow;
        }
        helpMessage.append("\nEnd of help.");
        return helpMessage.toString();
    }

    private void sendCustomHelpMessage(FtpIoSession session, String message) {
        session.write((Object)new DefaultFtpReply(214, message));
    }

    private void handleRequestWithArgument(FtpIoSession session, FtpRequest request) {
        String ftpCommand = request.getArgument().toUpperCase();
        String commandSpecificHelp = null;
        if (this.availableCommands.contains(ftpCommand)) {
            commandSpecificHelp = COMMAND_SPECIFIC_HELP.get(ftpCommand);
        }
        if (commandSpecificHelp == null) {
            this.sendDefaultHelpMessage(session);
        } else {
            this.sendCustomHelpMessage(session, commandSpecificHelp);
        }
    }
}

