/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.ftp.commands;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ftpserver.command.Command;
import org.apache.ftpserver.command.impl.ABOR;
import org.apache.ftpserver.command.impl.AUTH;
import org.apache.ftpserver.command.impl.CDUP;
import org.apache.ftpserver.command.impl.CWD;
import org.apache.ftpserver.command.impl.EPRT;
import org.apache.ftpserver.command.impl.EPSV;
import org.apache.ftpserver.command.impl.FEAT;
import org.apache.ftpserver.command.impl.LIST;
import org.apache.ftpserver.command.impl.MDTM;
import org.apache.ftpserver.command.impl.MKD;
import org.apache.ftpserver.command.impl.MLSD;
import org.apache.ftpserver.command.impl.MLST;
import org.apache.ftpserver.command.impl.MODE;
import org.apache.ftpserver.command.impl.NLST;
import org.apache.ftpserver.command.impl.NOOP;
import org.apache.ftpserver.command.impl.OPTS;
import org.apache.ftpserver.command.impl.PASS;
import org.apache.ftpserver.command.impl.PASV;
import org.apache.ftpserver.command.impl.PBSZ;
import org.apache.ftpserver.command.impl.PORT;
import org.apache.ftpserver.command.impl.PROT;
import org.apache.ftpserver.command.impl.PWD;
import org.apache.ftpserver.command.impl.QUIT;
import org.apache.ftpserver.command.impl.REIN;
import org.apache.ftpserver.command.impl.RMD;
import org.apache.ftpserver.command.impl.SITE;
import org.apache.ftpserver.command.impl.SITE_DESCUSER;
import org.apache.ftpserver.command.impl.SITE_HELP;
import org.apache.ftpserver.command.impl.SITE_STAT;
import org.apache.ftpserver.command.impl.SITE_WHO;
import org.apache.ftpserver.command.impl.SITE_ZONE;
import org.apache.ftpserver.command.impl.SIZE;
import org.apache.ftpserver.command.impl.STAT;
import org.apache.ftpserver.command.impl.STRU;
import org.apache.ftpserver.command.impl.SYST;
import org.apache.ftpserver.command.impl.TYPE;
import org.apache.ftpserver.command.impl.USER;
import org.apache.nifi.processor.ProcessSessionFactory;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processors.standard.ftp.commands.FtpCommandHELP;
import org.apache.nifi.processors.standard.ftp.commands.FtpCommandSTOR;
import org.apache.nifi.processors.standard.ftp.commands.NotSupportedCommand;

public class CommandMapFactory {
    private final Map<String, Command> commandMap = new HashMap<String, Command>();
    private final FtpCommandHELP customHelpCommand = new FtpCommandHELP();
    private final AtomicReference<ProcessSessionFactory> sessionFactory;
    private final CountDownLatch sessionFactorySetSignal;
    private final Relationship relationshipSuccess;

    public CommandMapFactory(AtomicReference<ProcessSessionFactory> sessionFactory, CountDownLatch sessionFactorySetSignal, Relationship relationshipSuccess) {
        this.sessionFactory = sessionFactory;
        this.sessionFactorySetSignal = sessionFactorySetSignal;
        this.relationshipSuccess = relationshipSuccess;
    }

    public Map<String, Command> createCommandMap() {
        this.addToCommandMap("ABOR", (Command)new ABOR());
        this.addToCommandMap("ACCT", (Command)new NotSupportedCommand("Operation (ACCT) not supported."));
        this.addToCommandMap("APPE", (Command)new NotSupportedCommand("Operation (APPE) not supported."));
        this.addToCommandMap("AUTH", (Command)new AUTH());
        this.addToCommandMap("CDUP", (Command)new CDUP());
        this.addToCommandMap("CWD", (Command)new CWD());
        this.addToCommandMap("DELE", (Command)new NotSupportedCommand("Operation (DELE) not supported."));
        this.addToCommandMap("EPRT", (Command)new EPRT());
        this.addToCommandMap("EPSV", (Command)new EPSV());
        this.addToCommandMap("FEAT", (Command)new FEAT());
        this.addToCommandMap("HELP", (Command)this.customHelpCommand);
        this.addToCommandMap("LIST", (Command)new LIST());
        this.addToCommandMap("MFMT", (Command)new NotSupportedCommand("Operation (MFMT) not supported."));
        this.addToCommandMap("MDTM", (Command)new MDTM());
        this.addToCommandMap("MLST", (Command)new MLST());
        this.addToCommandMap("MKD", (Command)new MKD());
        this.addToCommandMap("MLSD", (Command)new MLSD());
        this.addToCommandMap("MODE", (Command)new MODE());
        this.addToCommandMap("NLST", (Command)new NLST());
        this.addToCommandMap("NOOP", (Command)new NOOP());
        this.addToCommandMap("OPTS", (Command)new OPTS());
        this.addToCommandMap("PASS", (Command)new PASS());
        this.addToCommandMap("PASV", (Command)new PASV());
        this.addToCommandMap("PBSZ", (Command)new PBSZ());
        this.addToCommandMap("PORT", (Command)new PORT());
        this.addToCommandMap("PROT", (Command)new PROT());
        this.addToCommandMap("PWD", (Command)new PWD());
        this.addToCommandMap("QUIT", (Command)new QUIT());
        this.addToCommandMap("REIN", (Command)new REIN());
        this.addToCommandMap("REST", (Command)new NotSupportedCommand("Operation (REST) not supported."));
        this.addToCommandMap("RETR", (Command)new NotSupportedCommand("Operation (RETR) not supported."));
        this.addToCommandMap("RMD", (Command)new RMD());
        this.addToCommandMap("RNFR", (Command)new NotSupportedCommand("Operation (RNFR) not supported."));
        this.addToCommandMap("RNTO", (Command)new NotSupportedCommand("Operation (RNTO) not supported."));
        this.addToCommandMap("SITE", (Command)new SITE());
        this.addToCommandMap("SIZE", (Command)new SIZE());
        this.addToCommandMap("SITE_DESCUSER", (Command)new SITE_DESCUSER());
        this.addToCommandMap("SITE_HELP", (Command)new SITE_HELP());
        this.addToCommandMap("SITE_STAT", (Command)new SITE_STAT());
        this.addToCommandMap("SITE_WHO", (Command)new SITE_WHO());
        this.addToCommandMap("SITE_ZONE", (Command)new SITE_ZONE());
        this.addToCommandMap("STAT", (Command)new STAT());
        this.addToCommandMap("STOR", (Command)new FtpCommandSTOR(this.sessionFactory, this.sessionFactorySetSignal, this.relationshipSuccess));
        this.addToCommandMap("STOU", (Command)new NotSupportedCommand("Operation (STOU) not supported."));
        this.addToCommandMap("STRU", (Command)new STRU());
        this.addToCommandMap("SYST", (Command)new SYST());
        this.addToCommandMap("TYPE", (Command)new TYPE());
        this.addToCommandMap("USER", (Command)new USER());
        return this.commandMap;
    }

    private void addToCommandMap(String command, Command instance) {
        this.commandMap.put(command, instance);
        if (!(instance instanceof NotSupportedCommand)) {
            this.customHelpCommand.addCommand(command);
        }
    }
}

