/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.db;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.database.dialect.service.api.ColumnDefinition;
import org.apache.nifi.database.dialect.service.api.DatabaseDialectService;
import org.apache.nifi.database.dialect.service.api.PageRequest;
import org.apache.nifi.database.dialect.service.api.QueryStatementRequest;
import org.apache.nifi.database.dialect.service.api.StandardStatementResponse;
import org.apache.nifi.database.dialect.service.api.StatementRequest;
import org.apache.nifi.database.dialect.service.api.StatementResponse;
import org.apache.nifi.database.dialect.service.api.StatementType;
import org.apache.nifi.database.dialect.service.api.TableDefinition;
import org.apache.nifi.processors.standard.db.ColumnDescription;
import org.apache.nifi.processors.standard.db.DatabaseAdapter;
import org.apache.nifi.processors.standard.db.DatabaseAdapterDescriptor;
import org.apache.nifi.processors.standard.db.TableSchema;

class DatabaseAdapterDatabaseDialectService
extends AbstractControllerService
implements DatabaseDialectService {
    private static final char SPACE_SEPARATOR = ' ';
    private static final char COMMA_SEPARATOR = ',';
    private static final int COLUMN_SIZE_IGNORED = -1;
    private static final String DOUBLE_QUOTE = "\"";
    private final DatabaseAdapter databaseAdapter;
    private final Set<StatementType> supportedStatementTypes;

    public DatabaseAdapterDatabaseDialectService(String databaseType) {
        Objects.requireNonNull(databaseType, "Database Type required");
        this.databaseAdapter = DatabaseAdapterDescriptor.getDatabaseAdapter(databaseType);
        Objects.requireNonNull(this.databaseAdapter, "Database Adapter required");
        LinkedHashSet<StatementType> statementTypes = new LinkedHashSet<StatementType>();
        statementTypes.add(StatementType.ALTER);
        statementTypes.add(StatementType.CREATE);
        statementTypes.add(StatementType.SELECT);
        if (this.databaseAdapter.supportsInsertIgnore()) {
            statementTypes.add(StatementType.INSERT_IGNORE);
        }
        if (this.databaseAdapter.supportsUpsert()) {
            statementTypes.add(StatementType.UPSERT);
        }
        this.supportedStatementTypes = Collections.unmodifiableSet(statementTypes);
    }

    public StatementResponse getStatement(StatementRequest statementRequest) {
        String sql;
        StatementType statementType = statementRequest.statementType();
        TableDefinition tableDefinition = statementRequest.tableDefinition();
        List<String> columnNames = tableDefinition.columns().stream().map(ColumnDefinition::columnName).toList();
        List<String> primaryKeyColumnNames = tableDefinition.columns().stream().filter(ColumnDefinition::primaryKey).map(ColumnDefinition::columnName).toList();
        List<ColumnDescription> columnDescriptions = this.getColumnDescriptions(tableDefinition);
        if (StatementType.ALTER == statementType) {
            sql = this.databaseAdapter.getAlterTableStatement(tableDefinition.tableName(), columnDescriptions);
        } else if (StatementType.CREATE == statementType) {
            TableSchema tableSchema = this.getTableSchema(tableDefinition);
            sql = this.databaseAdapter.getCreateTableStatement(tableSchema);
        } else if (StatementType.UPSERT == statementType) {
            sql = this.databaseAdapter.getUpsertStatement(tableDefinition.tableName(), columnNames, primaryKeyColumnNames);
        } else if (StatementType.INSERT_IGNORE == statementType) {
            sql = this.databaseAdapter.getInsertIgnoreStatement(tableDefinition.tableName(), columnNames, primaryKeyColumnNames);
        } else if (StatementType.SELECT == statementType) {
            sql = this.getSelectStatement(statementRequest);
        } else {
            throw new UnsupportedOperationException("Statement Type [%s] not supported".formatted(statementType));
        }
        return new StandardStatementResponse(sql);
    }

    public Set<StatementType> getSupportedStatementTypes() {
        return this.supportedStatementTypes;
    }

    private String getSelectStatement(StatementRequest statementRequest) {
        if (statementRequest instanceof QueryStatementRequest) {
            String selectTableSql;
            QueryStatementRequest queryStatementRequest = (QueryStatementRequest)statementRequest;
            TableDefinition tableDefinition = statementRequest.tableDefinition();
            String qualifiedTableName = tableDefinition.tableName();
            Optional derivedTableFound = queryStatementRequest.derivedTable();
            if (derivedTableFound.isPresent()) {
                String derivedTable = (String)derivedTableFound.get();
                String tableAlias = this.databaseAdapter.getTableAliasClause(qualifiedTableName);
                selectTableSql = "SELECT * FROM (%s) %s".formatted(derivedTable, tableAlias);
            } else {
                String indexColumnName;
                Long offset;
                Long limit;
                String tableColumns = this.getSelectTableColumns(tableDefinition.columns());
                Optional pageRequestFound = queryStatementRequest.pageRequest();
                if (pageRequestFound.isPresent()) {
                    PageRequest pageRequest = (PageRequest)pageRequestFound.get();
                    limit = pageRequest.limit().isPresent() ? Long.valueOf(pageRequest.limit().getAsLong()) : null;
                    offset = pageRequest.offset();
                    indexColumnName = pageRequest.indexColumnName().orElse(null);
                } else {
                    limit = null;
                    offset = null;
                    indexColumnName = null;
                }
                String whereSql = queryStatementRequest.whereClause().orElse(null);
                String orderBySql = queryStatementRequest.orderByClause().orElse(null);
                selectTableSql = this.databaseAdapter.getSelectStatement(qualifiedTableName, tableColumns, whereSql, orderBySql, limit, offset, indexColumnName);
            }
            return selectTableSql;
        }
        throw new IllegalArgumentException("Query Statement Request not found [%s]".formatted(statementRequest.getClass()));
    }

    private String getSelectTableColumns(List<ColumnDefinition> columnDefinitions) {
        StringBuilder tableColumns = new StringBuilder();
        Iterator<ColumnDefinition> columns = columnDefinitions.iterator();
        while (columns.hasNext()) {
            ColumnDefinition columnDefinition = columns.next();
            String columnName = columnDefinition.columnName();
            tableColumns.append(columnName);
            if (!columns.hasNext()) continue;
            tableColumns.append(',');
            tableColumns.append(' ');
        }
        return tableColumns.toString();
    }

    private List<ColumnDescription> getColumnDescriptions(TableDefinition tableDefinition) {
        return tableDefinition.columns().stream().map(columnDefinition -> new ColumnDescription(columnDefinition.columnName(), columnDefinition.dataType(), columnDefinition.primaryKey(), -1, columnDefinition.nullable() == ColumnDefinition.Nullable.YES)).toList();
    }

    private TableSchema getTableSchema(TableDefinition tableDefinition) {
        List<ColumnDescription> columnDescriptions = this.getColumnDescriptions(tableDefinition);
        Set<String> primaryKeyColumnNames = tableDefinition.columns().stream().filter(ColumnDefinition::primaryKey).map(ColumnDefinition::columnName).collect(Collectors.toUnmodifiableSet());
        return new TableSchema(tableDefinition.catalog().orElse(null), tableDefinition.schemaName().orElse(null), tableDefinition.tableName(), columnDescriptions, false, null, primaryKeyColumnNames, DOUBLE_QUOTE);
    }
}

