/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.parameter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.ConfigVerificationResult;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.parameter.AbstractParameterProvider;
import org.apache.nifi.parameter.Parameter;
import org.apache.nifi.parameter.ParameterGroup;
import org.apache.nifi.parameter.VerifiableParameterProvider;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.web.client.api.HttpResponseEntity;
import org.apache.nifi.web.client.api.HttpUriBuilder;
import org.apache.nifi.web.client.provider.api.WebClientServiceProvider;

@Tags(value={"1Password"})
@CapabilityDescription(value="Fetches parameters from 1Password Connect Server")
public class OnePasswordParameterProvider
extends AbstractParameterProvider
implements VerifiableParameterProvider {
    public static final PropertyDescriptor WEB_CLIENT_SERVICE_PROVIDER = new PropertyDescriptor.Builder().name("Web Client Service Provider").description("Controller service for HTTP client operations.").identifiesControllerService(WebClientServiceProvider.class).required(true).build();
    public static final PropertyDescriptor CONNECT_SERVER = new PropertyDescriptor.Builder().name("Connect Server").description("HTTP endpoint of the 1Password Connect Server to connect to. Example: http://localhost:8080").required(true).addValidator(StandardValidators.URL_VALIDATOR).build();
    public static final PropertyDescriptor ACCESS_TOKEN = new PropertyDescriptor.Builder().name("Access Token").description("Access Token used for authentication against the 1Password APIs.").sensitive(true).required(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    private static final String VERSION = "v1";
    private static final String GET_VAULTS = "vaults";
    private static final String GET_ITEMS = "items";
    private static final String CONTENT_TYPE = "Content-type";
    private static final String APPLICATION_JSON = "application/json";
    private static final String AUTHORIZATION_HEADER_NAME = "Authorization";
    private static final String AUTHORIZATION_HEADER_VALUE = "Bearer ";
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final List<PropertyDescriptor> DESCRIPTORS = List.of(WEB_CLIENT_SERVICE_PROVIDER, CONNECT_SERVER, ACCESS_TOKEN);
    private volatile WebClientServiceProvider webClientServiceProvider;

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return DESCRIPTORS;
    }

    public List<ConfigVerificationResult> verify(ConfigurationContext context, ComponentLog verificationLogger) {
        ArrayList<ConfigVerificationResult> results = new ArrayList<ConfigVerificationResult>();
        this.webClientServiceProvider = (WebClientServiceProvider)context.getProperty(WEB_CLIENT_SERVICE_PROVIDER).asControllerService(WebClientServiceProvider.class);
        String connectServer = context.getProperty(CONNECT_SERVER).getValue();
        URI uri = URI.create(connectServer);
        String accessToken = context.getProperty(ACCESS_TOKEN).getValue();
        try {
            JsonNode vaultList = this.getVaultList(uri, accessToken);
            results.add(new ConfigVerificationResult.Builder().outcome(ConfigVerificationResult.Outcome.SUCCESSFUL).verificationStepName("Listing Vaults").explanation(String.format("Listed Vaults [%d]", vaultList.size())).build());
        }
        catch (IOException | IllegalArgumentException e) {
            verificationLogger.error("Listing Vaults failed", (Throwable)e);
            results.add(new ConfigVerificationResult.Builder().outcome(ConfigVerificationResult.Outcome.FAILED).verificationStepName("Listing Vaults").explanation("Listing Vaults failed: " + e.getMessage()).build());
        }
        return results;
    }

    private JsonNode getVaultList(URI connectServer, String accessToken) throws IOException {
        try (HttpResponseEntity getVaultList = this.webClientServiceProvider.getWebClientService().get().uri(this.getURI(connectServer, null, null)).header(AUTHORIZATION_HEADER_NAME, AUTHORIZATION_HEADER_VALUE + accessToken).header(CONTENT_TYPE, APPLICATION_JSON).retrieve();){
            JsonNode jsonNode = OBJECT_MAPPER.readTree(getVaultList.body());
            return jsonNode;
        }
    }

    private JsonNode getItemList(URI connectServer, String accessToken, String vaultID) throws IOException {
        try (HttpResponseEntity getVaultItems = this.webClientServiceProvider.getWebClientService().get().uri(this.getURI(connectServer, vaultID, null)).header(AUTHORIZATION_HEADER_NAME, AUTHORIZATION_HEADER_VALUE + accessToken).header(CONTENT_TYPE, APPLICATION_JSON).retrieve();){
            JsonNode jsonNode = OBJECT_MAPPER.readTree(getVaultItems.body());
            return jsonNode;
        }
    }

    private JsonNode getItemDetails(URI connectServer, String accessToken, String vaultID, String itemID) throws IOException {
        try (HttpResponseEntity getItemDetails = this.webClientServiceProvider.getWebClientService().get().uri(this.getURI(connectServer, vaultID, itemID)).header(AUTHORIZATION_HEADER_NAME, AUTHORIZATION_HEADER_VALUE + accessToken).header(CONTENT_TYPE, APPLICATION_JSON).retrieve();){
            JsonNode jsonNode = OBJECT_MAPPER.readTree(getItemDetails.body());
            return jsonNode;
        }
    }

    private URI getURI(URI connectServer, String vaultID, String itemID) {
        HttpUriBuilder uriBuilder = this.webClientServiceProvider.getHttpUriBuilder().scheme(connectServer.getScheme()).host(connectServer.getHost()).port(connectServer.getPort()).addPathSegment(VERSION).addPathSegment(GET_VAULTS);
        if (vaultID != null) {
            uriBuilder.addPathSegment(vaultID).addPathSegment(GET_ITEMS);
        }
        if (itemID != null) {
            uriBuilder.addPathSegment(itemID);
        }
        return uriBuilder.build();
    }

    public List<ParameterGroup> fetchParameters(ConfigurationContext context) {
        this.webClientServiceProvider = (WebClientServiceProvider)context.getProperty(WEB_CLIENT_SERVICE_PROVIDER).asControllerService(WebClientServiceProvider.class);
        ArrayList<ParameterGroup> parameterGroups = new ArrayList<ParameterGroup>();
        String connectServer = context.getProperty(CONNECT_SERVER).getValue();
        URI uri = URI.create(connectServer);
        String accessToken = context.getProperty(ACCESS_TOKEN).getValue();
        try {
            JsonNode vaultList = this.getVaultList(uri, accessToken);
            Iterator vaultIterator = vaultList.elements();
            while (vaultIterator.hasNext()) {
                JsonNode vault = (JsonNode)vaultIterator.next();
                String vaultName = vault.get("name").asText();
                String vaultID = vault.get("id").asText();
                ArrayList<Parameter> parameters = new ArrayList<Parameter>();
                JsonNode itemList = this.getItemList(uri, accessToken, vaultID);
                Iterator itemIterator = itemList.elements();
                while (itemIterator.hasNext()) {
                    JsonNode item = (JsonNode)itemIterator.next();
                    String itemID = item.get("id").asText();
                    JsonNode itemDetails = this.getItemDetails(uri, accessToken, vaultID, itemID);
                    String itemName = itemDetails.get("title").asText();
                    Iterator itemFields = itemDetails.get("fields").elements();
                    while (itemFields.hasNext()) {
                        JsonNode field = (JsonNode)itemFields.next();
                        String fieldId = field.get("id").asText();
                        JsonNode fieldValue = field.get("value");
                        if (fieldValue == null) continue;
                        parameters.add(new Parameter.Builder().name(itemName + "_" + fieldId).value(fieldValue.asText()).provided(Boolean.valueOf(true)).build());
                    }
                }
                parameterGroups.add(new ParameterGroup(vaultName, parameters));
            }
        }
        catch (IOException | IllegalArgumentException e) {
            throw new RuntimeException("Failed to retrieve items for one or more Vaults", e);
        }
        AtomicInteger groupedParameterCount = new AtomicInteger(0);
        HashSet groupNames = new HashSet();
        parameterGroups.forEach(group -> {
            groupedParameterCount.addAndGet(group.getParameters().size());
            groupNames.add(group.getGroupName());
        });
        this.getLogger().info("Fetched {} parameters with Group Names: {}", new Object[]{groupedParameterCount.get(), groupNames});
        return parameterGroups;
    }
}

