/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.ssl;

import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnDisabled;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.ConfigVerificationResult;
import org.apache.nifi.components.DescribedValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.resource.ResourceCardinality;
import org.apache.nifi.components.resource.ResourceReference;
import org.apache.nifi.components.resource.ResourceType;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.controller.VerifiableControllerService;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.reporting.InitializationException;
import org.apache.nifi.security.ssl.BuilderConfigurationException;
import org.apache.nifi.security.ssl.PemCertificateKeyStoreBuilder;
import org.apache.nifi.security.ssl.PemPrivateKeyCertificateKeyStoreBuilder;
import org.apache.nifi.security.ssl.StandardKeyManagerBuilder;
import org.apache.nifi.security.ssl.StandardSslContextBuilder;
import org.apache.nifi.security.ssl.StandardTrustManagerBuilder;
import org.apache.nifi.security.util.TlsPlatform;
import org.apache.nifi.ssl.SSLContextProvider;

@Tags(value={"PEM", "SSL", "TLS", "Key", "Certificate", "PKCS1", "PKCS8", "X.509", "ECDSA", "Ed25519", "RSA"})
@CapabilityDescription(value="    SSLContext Provider configurable using PEM Private Key and Certificate files.\n    Supports PKCS1 and PKCS8 encoding for Private Keys as well as X.509 encoding for Certificates.\n")
public class PEMEncodedSSLContextProvider
extends AbstractControllerService
implements SSLContextProvider,
VerifiableControllerService {
    static final String DEFAULT_PROTOCOL = "TLS";
    static final PropertyDescriptor TLS_PROTOCOL = new PropertyDescriptor.Builder().name("TLS Protocol").description("TLS protocol version required for negotiating encrypted communications.").required(true).sensitive(false).defaultValue("TLS").allowableValues((DescribedValue[])PEMEncodedSSLContextProvider.getProtocolAllowableValues()).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    static final PropertyDescriptor PRIVATE_KEY_SOURCE = new PropertyDescriptor.Builder().name("Private Key Source").description("Source of information for loading Private Key and Certificate Chain").required(true).defaultValue((DescribedValue)PrivateKeySource.PROPERTIES).allowableValues(PrivateKeySource.class).build();
    static final PropertyDescriptor PRIVATE_KEY = new PropertyDescriptor.Builder().name("Private Key").description("PEM Private Key encoded using either PKCS1 or PKCS8. Supported algorithms include ECDSA, Ed25519, and RSA").required(true).sensitive(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).identifiesExternalResource(ResourceCardinality.SINGLE, ResourceType.TEXT, new ResourceType[0]).dependsOn(PRIVATE_KEY_SOURCE, (DescribedValue)PrivateKeySource.PROPERTIES, new DescribedValue[0]).build();
    static final PropertyDescriptor PRIVATE_KEY_LOCATION = new PropertyDescriptor.Builder().name("Private Key Location").description("PEM Private Key file location encoded using either PKCS1 or PKCS8. Supported algorithms include ECDSA, Ed25519, and RSA").required(true).sensitive(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).identifiesExternalResource(ResourceCardinality.SINGLE, ResourceType.FILE, new ResourceType[0]).dependsOn(PRIVATE_KEY_SOURCE, (DescribedValue)PrivateKeySource.FILES, new DescribedValue[0]).build();
    static final PropertyDescriptor CERTIFICATE_CHAIN = new PropertyDescriptor.Builder().name("Certificate Chain").description("PEM X.509 Certificate Chain associated with Private Key starting with standard BEGIN CERTIFICATE header").required(true).sensitive(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).identifiesExternalResource(ResourceCardinality.SINGLE, ResourceType.TEXT, new ResourceType[0]).dependsOn(PRIVATE_KEY_SOURCE, (DescribedValue)PrivateKeySource.PROPERTIES, new DescribedValue[0]).build();
    static final PropertyDescriptor CERTIFICATE_CHAIN_LOCATION = new PropertyDescriptor.Builder().name("Certificate Chain Location").description("PEM X.509 Certificate Chain file location associated with Private Key starting with standard BEGIN CERTIFICATE header").required(true).sensitive(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).identifiesExternalResource(ResourceCardinality.SINGLE, ResourceType.FILE, new ResourceType[0]).dependsOn(PRIVATE_KEY_SOURCE, (DescribedValue)PrivateKeySource.FILES, new DescribedValue[0]).build();
    static final PropertyDescriptor CERTIFICATE_AUTHORITIES_SOURCE = new PropertyDescriptor.Builder().name("Certificate Authorities Source").description("Source of information for loading trusted Certificate Authorities").required(true).defaultValue((DescribedValue)CertificateAuthoritiesSource.PROPERTIES).allowableValues(CertificateAuthoritiesSource.class).build();
    static final PropertyDescriptor CERTIFICATE_AUTHORITIES = new PropertyDescriptor.Builder().name("Certificate Authorities").description("PEM X.509 Certificate Authorities trusted for verifying peers in TLS communications containing one or more standard certificates").required(true).sensitive(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).identifiesExternalResource(ResourceCardinality.SINGLE, ResourceType.FILE, new ResourceType[]{ResourceType.TEXT}).dependsOn(CERTIFICATE_AUTHORITIES_SOURCE, (DescribedValue)CertificateAuthoritiesSource.PROPERTIES, new DescribedValue[0]).build();
    private static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS = List.of(TLS_PROTOCOL, PRIVATE_KEY_SOURCE, PRIVATE_KEY, PRIVATE_KEY_LOCATION, CERTIFICATE_CHAIN, CERTIFICATE_CHAIN_LOCATION, CERTIFICATE_AUTHORITIES_SOURCE, CERTIFICATE_AUTHORITIES);
    private static final char[] EMPTY_PROTECTION_PARAMETER = new char[0];
    private String protocol = "TLS";
    private KeyStore keyStore;
    private KeyStore trustStore;

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    public List<ConfigVerificationResult> verify(ConfigurationContext context, ComponentLog verificationLogger, Map<String, String> variables) {
        ArrayList<ConfigVerificationResult> results = new ArrayList<ConfigVerificationResult>();
        ConfigVerificationResult.Builder privateKeyBuilder = new ConfigVerificationResult.Builder().verificationStepName("Load Private Key and Certificate Chain");
        PrivateKeySource privateKeySource = (PrivateKeySource)context.getProperty(PRIVATE_KEY_SOURCE).asAllowableValue(PrivateKeySource.class);
        if (privateKeySource == PrivateKeySource.UNDEFINED) {
            privateKeyBuilder.outcome(ConfigVerificationResult.Outcome.SKIPPED).explanation("Private Key and Certificate Chain properties not required");
        } else {
            try {
                this.loadKeyStore(context);
                privateKeyBuilder.outcome(ConfigVerificationResult.Outcome.SUCCESSFUL);
            }
            catch (Exception e) {
                privateKeyBuilder.outcome(ConfigVerificationResult.Outcome.FAILED).explanation(e.getMessage());
            }
        }
        results.add(privateKeyBuilder.build());
        ConfigVerificationResult.Builder authoritiesBuilder = new ConfigVerificationResult.Builder().verificationStepName("Load Certificate Authorities");
        try {
            this.loadTrustStore(context);
            authoritiesBuilder.outcome(ConfigVerificationResult.Outcome.SUCCESSFUL);
        }
        catch (Exception e) {
            authoritiesBuilder.outcome(ConfigVerificationResult.Outcome.FAILED).explanation(e.getMessage());
        }
        results.add(authoritiesBuilder.build());
        return results;
    }

    @OnEnabled
    public void onEnabled(ConfigurationContext context) throws InitializationException {
        this.protocol = context.getProperty(TLS_PROTOCOL).getValue();
        this.loadKeyStore(context);
        this.loadTrustStore(context);
    }

    @OnDisabled
    public void onDisabled() {
        this.keyStore = null;
        this.trustStore = null;
    }

    public SSLContext createContext() {
        StandardSslContextBuilder sslContextBuilder = new StandardSslContextBuilder();
        sslContextBuilder.protocol(this.protocol);
        X509TrustManager trustManager = this.createTrustManager();
        sslContextBuilder.trustManager((TrustManager)trustManager);
        Optional<X509ExtendedKeyManager> keyManagerCreated = this.createKeyManager();
        if (keyManagerCreated.isPresent()) {
            X509ExtendedKeyManager keyManager = keyManagerCreated.get();
            sslContextBuilder.keyManager((KeyManager)keyManager);
        }
        return sslContextBuilder.build();
    }

    public Optional<X509ExtendedKeyManager> createKeyManager() {
        Optional<X509ExtendedKeyManager> keyManagerCreated;
        if (this.keyStore == null) {
            keyManagerCreated = Optional.empty();
        } else {
            X509ExtendedKeyManager keyManager = new StandardKeyManagerBuilder().keyStore(this.keyStore).keyPassword(EMPTY_PROTECTION_PARAMETER).build();
            keyManagerCreated = Optional.of(keyManager);
        }
        return keyManagerCreated;
    }

    public X509TrustManager createTrustManager() {
        X509ExtendedTrustManager trustManager;
        if (this.trustStore == null) {
            try {
                String algorithm = TrustManagerFactory.getDefaultAlgorithm();
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(algorithm);
                trustManagerFactory.init(this.trustStore);
                TrustManager[] trustManagers = trustManagerFactory.getTrustManagers();
                Optional<X509ExtendedTrustManager> configuredTrustManager = Arrays.stream(trustManagers).filter(manager -> manager instanceof X509ExtendedTrustManager).map(manager -> (X509ExtendedTrustManager)manager).findFirst();
                trustManager = configuredTrustManager.orElseThrow(() -> new BuilderConfigurationException("X.509 Trust Manager not configured"));
            }
            catch (GeneralSecurityException e) {
                throw new BuilderConfigurationException("Trust Manager creation failed for System Certificate Authorities", (Throwable)e);
            }
        } else {
            trustManager = new StandardTrustManagerBuilder().trustStore(this.trustStore).build();
        }
        return trustManager;
    }

    private void loadKeyStore(ConfigurationContext context) throws InitializationException {
        PrivateKeySource privateKeySource = (PrivateKeySource)context.getProperty(PRIVATE_KEY_SOURCE).asAllowableValue(PrivateKeySource.class);
        if (privateKeySource == PrivateKeySource.UNDEFINED) {
            this.getLogger().debug("Private Key and Certificate Chain not configured");
        } else {
            PropertyDescriptor certificateChainProperty;
            PropertyDescriptor privateKeyProperty;
            if (privateKeySource == PrivateKeySource.FILES) {
                privateKeyProperty = PRIVATE_KEY_LOCATION;
                certificateChainProperty = CERTIFICATE_CHAIN_LOCATION;
            } else {
                privateKeyProperty = PRIVATE_KEY;
                certificateChainProperty = CERTIFICATE_CHAIN;
            }
            ResourceReference privateKeyReference = context.getProperty(privateKeyProperty).asResource();
            ResourceReference certificateChainReference = context.getProperty(certificateChainProperty).asResource();
            PemPrivateKeyCertificateKeyStoreBuilder keyStoreBuilder = new PemPrivateKeyCertificateKeyStoreBuilder();
            try (InputStream privateKeyInputStream = privateKeyReference.read();
                 InputStream certificateInputStream = certificateChainReference.read();){
                this.keyStore = keyStoreBuilder.privateKeyInputStream(privateKeyInputStream).certificateInputStream(certificateInputStream).build();
            }
            catch (Exception e) {
                throw new InitializationException("Failed to load Private Key or Certificate Chain from configured properties", (Throwable)e);
            }
        }
    }

    private void loadTrustStore(ConfigurationContext context) throws InitializationException {
        CertificateAuthoritiesSource certificateAuthoritiesSource = (CertificateAuthoritiesSource)context.getProperty(CERTIFICATE_AUTHORITIES_SOURCE).asAllowableValue(CertificateAuthoritiesSource.class);
        if (certificateAuthoritiesSource == CertificateAuthoritiesSource.SYSTEM) {
            this.trustStore = null;
        } else if (certificateAuthoritiesSource == CertificateAuthoritiesSource.PROPERTIES) {
            ResourceReference certificateAuthoritiesReference = context.getProperty(CERTIFICATE_AUTHORITIES).asResource();
            try (InputStream certificateAuthoritiesStream = certificateAuthoritiesReference.read();){
                this.trustStore = new PemCertificateKeyStoreBuilder().inputStream(certificateAuthoritiesStream).build();
            }
            catch (Exception e) {
                throw new InitializationException("Failed to load Certificate Authorities from configured properties", (Throwable)e);
            }
        }
    }

    private static AllowableValue[] getProtocolAllowableValues() {
        ArrayList<AllowableValue> allowableValues = new ArrayList<AllowableValue>();
        allowableValues.add(new AllowableValue(DEFAULT_PROTOCOL, DEFAULT_PROTOCOL, "Negotiate latest TLS protocol version based on platform supported versions"));
        for (String supportedProtocol : TlsPlatform.getPreferredProtocols()) {
            String description = String.format("Require %s protocol version", supportedProtocol);
            allowableValues.add(new AllowableValue(supportedProtocol, supportedProtocol, description));
        }
        return allowableValues.toArray(new AllowableValue[0]);
    }

    static enum PrivateKeySource implements DescribedValue
    {
        UNDEFINED("Undefined", "Avoid configuring Private Key and Certificate Chain properties"),
        PROPERTIES("Properties", "Load Private Key and Certificate Chain from configured properties"),
        FILES("Files", "Load Private Key and Certificate Chain from configured files");

        private final String displayName;
        private final String description;

        private PrivateKeySource(String displayName, String description) {
            this.displayName = displayName;
            this.description = description;
        }

        public String getValue() {
            return this.name();
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getDescription() {
            return this.description;
        }
    }

    static enum CertificateAuthoritiesSource implements DescribedValue
    {
        PROPERTIES("Properties", "Load trusted Certificate Authorities from configured properties"),
        SYSTEM("System", "Load trusted Certificate Authorities from the default system location");

        private final String displayName;
        private final String description;

        private CertificateAuthoritiesSource(String displayName, String description) {
            this.displayName = displayName;
            this.description = description;
        }

        public String getValue() {
            return this.name();
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

