/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.reporting.sql.datasources;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.metrics.jvm.JmxJvmMetrics;
import org.apache.nifi.metrics.jvm.JvmMetrics;
import org.apache.nifi.processor.DataUnit;
import org.apache.nifi.sql.ColumnSchema;
import org.apache.nifi.sql.IterableRowStream;
import org.apache.nifi.sql.NiFiTableSchema;
import org.apache.nifi.sql.ResettableDataSource;
import org.apache.nifi.sql.RowStream;

public class JvmMetricsDataSource
implements ResettableDataSource {
    private static final NiFiTableSchema BASE_SCHEMA = new NiFiTableSchema(List.of(new ColumnSchema("jvm.daemon_thread_count".replaceAll("[.-]", "_"), Integer.TYPE, false), new ColumnSchema("jvm.thread_count".replaceAll("[.-]", "_"), Integer.TYPE, false), new ColumnSchema("jvm.thread_states.blocked".replaceAll("[.-]", "_"), Integer.TYPE, false), new ColumnSchema("jvm.thread_states.runnable".replaceAll("[.-]", "_"), Integer.TYPE, false), new ColumnSchema("jvm.thread_states.terminated".replaceAll("[.-]", "_"), Integer.TYPE, false), new ColumnSchema("jvm.thread_states.timed_waiting".replaceAll("[.-]", "_"), Integer.TYPE, false), new ColumnSchema("jvm.uptime".replaceAll("[.-]", "_"), Long.TYPE, false), new ColumnSchema("jvm.heap_used".replaceAll("[.-]", "_"), Double.TYPE, false), new ColumnSchema("jvm.heap_usage".replaceAll("[.-]", "_"), Double.TYPE, false), new ColumnSchema("jvm.non_heap_usage".replaceAll("[.-]", "_"), Double.TYPE, false), new ColumnSchema("jvm.file_descriptor_usage".replaceAll("[.-]", "_"), Double.TYPE, false)));
    private final JvmMetrics virtualMachineMetrics = JmxJvmMetrics.getInstance();
    private final NiFiTableSchema schema;

    public JvmMetricsDataSource() {
        ArrayList<ColumnSchema> columns = new ArrayList<ColumnSchema>(BASE_SCHEMA.columns());
        for (String gcName : this.virtualMachineMetrics.garbageCollectors().keySet()) {
            String gcRunsName = this.normalize("jvm.gc.runs_" + gcName);
            String gcTimeName = this.normalize("jvm.gc.time_" + gcName);
            columns.add(new ColumnSchema(gcRunsName, Long.TYPE, true));
            columns.add(new ColumnSchema(gcTimeName, Long.TYPE, true));
        }
        this.schema = new NiFiTableSchema(columns);
    }

    private String normalize(String value) {
        return value.replaceAll("[ -.]", "_");
    }

    public NiFiTableSchema getSchema() {
        return this.schema;
    }

    public RowStream reset() {
        ArrayList<Number> values = new ArrayList<Number>();
        values.add(this.virtualMachineMetrics.daemonThreadCount());
        values.add(this.virtualMachineMetrics.threadCount());
        values.add(this.getThreadStatePercentage(Thread.State.BLOCKED));
        values.add(this.getThreadStatePercentage(Thread.State.RUNNABLE));
        values.add(this.getThreadStatePercentage(Thread.State.TERMINATED));
        values.add(this.getThreadStatePercentage(Thread.State.TIMED_WAITING));
        values.add(this.virtualMachineMetrics.uptime());
        values.add(this.virtualMachineMetrics.heapUsed(DataUnit.B));
        values.add(this.virtualMachineMetrics.heapUsage());
        values.add(this.virtualMachineMetrics.nonHeapUsage());
        values.add(this.virtualMachineMetrics.fileDescriptorUsage());
        this.virtualMachineMetrics.garbageCollectors().values().forEach(gc -> {
            values.add(gc.getRuns());
            values.add(gc.getTime(TimeUnit.MILLISECONDS));
        });
        return new IterableRowStream(Collections.singleton(values), v -> v.toArray(new Object[0]));
    }

    private int getThreadStatePercentage(Thread.State threadState) {
        Double ratio = (Double)this.virtualMachineMetrics.threadStatePercentages().get((Object)threadState);
        if (ratio == null) {
            return 0;
        }
        return (int)(ratio * 100.0);
    }
}

