/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.reporting.sql.util;

import org.apache.calcite.config.Lex;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.Validator;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.record.sink.RecordSinkService;

public class QueryMetricsUtil {
    public static final PropertyDescriptor RECORD_SINK = new PropertyDescriptor.Builder().name("sql-reporting-record-sink").displayName("Record Destination Service").description("Specifies the Controller Service to use for writing out the query result records to some destination.").identifiesControllerService(RecordSinkService.class).required(true).build();
    public static final PropertyDescriptor QUERY = new PropertyDescriptor.Builder().name("sql-reporting-query").displayName("SQL Query").description("SQL SELECT statement specifies which tables to query and how data should be filtered/transformed. SQL SELECT can select from the CONNECTION_STATUS, PROCESSOR_STATUS, BULLETINS, PROCESS_GROUP_STATUS, JVM_METRICS, CONNECTION_STATUS_PREDICTIONS, or PROVENANCE tables. Note that the CONNECTION_STATUS_PREDICTIONS table is not available for querying if analytics are not enabled).").required(true).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).addValidator((Validator)new SqlValidator()).build();
    public static final PropertyDescriptor INCLUDE_ZERO_RECORD_RESULTS = new PropertyDescriptor.Builder().name("sql-reporting-include-zero-record-results").displayName("Include Zero Record Results").description("When running the SQL statement, if the result has no data, this property specifies whether or not the empty result set will be transmitted.").expressionLanguageSupported(ExpressionLanguageScope.NONE).allowableValues(new String[]{"true", "false"}).defaultValue("false").required(true).build();

    public static class SqlValidator
    implements Validator {
        public ValidationResult validate(String subject, String input, ValidationContext context) {
            if (context.isExpressionLanguagePresent(input)) {
                return new ValidationResult.Builder().input(input).subject(subject).valid(true).explanation("Expression Language Present").build();
            }
            String substituted = context.newPropertyValue(input).evaluateAttributeExpressions().getValue();
            SqlParser.Config config = SqlParser.config().withLex(Lex.MYSQL_ANSI);
            SqlParser parser = SqlParser.create((String)substituted, (SqlParser.Config)config);
            try {
                parser.parseStmt();
                return new ValidationResult.Builder().subject(subject).input(input).valid(true).build();
            }
            catch (Exception e) {
                return new ValidationResult.Builder().subject(subject).input(input).valid(false).explanation("Not a valid SQL Statement: " + e.getMessage()).build();
            }
        }
    }
}

