/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.snowflake.service.util;

import java.util.Objects;
import java.util.Optional;
import org.apache.nifi.components.DescribedValue;
import org.apache.nifi.snowflake.service.util.ConnectionUrlFormatParameters;

public enum ConnectionUrlFormat implements DescribedValue
{
    FULL_URL("full-url", "Full URL", "Provide connection URL in a single property"){

        @Override
        public String buildConnectionUrl(ConnectionUrlFormatParameters parameters) {
            Object snowflakeUrl = parameters.getSnowflakeUrl();
            if (!((String)snowflakeUrl).startsWith(ConnectionUrlFormat.SNOWFLAKE_SCHEME)) {
                snowflakeUrl = ConnectionUrlFormat.SNOWFLAKE_URI_PREFIX + (String)snowflakeUrl;
            }
            return snowflakeUrl;
        }
    }
    ,
    ACCOUNT_NAME("account-name", "Account Name", "Provide a Snowflake Account Name"){

        @Override
        public String buildConnectionUrl(ConnectionUrlFormatParameters parameters) {
            String organizationName = Objects.requireNonNull(parameters.getOrganizationName());
            String accountName = Objects.requireNonNull(parameters.getAccountName());
            return ConnectionUrlFormat.SNOWFLAKE_URI_PREFIX + organizationName + "-" + accountName + ConnectionUrlFormat.SNOWFLAKE_HOST_SUFFIX;
        }
    }
    ,
    ACCOUNT_LOCATOR("account-locator", "Account Locator", "Provide a Snowflake Account Locator"){

        @Override
        public String buildConnectionUrl(ConnectionUrlFormatParameters parameters) {
            String accountLocator = Objects.requireNonNull(parameters.getAccountLocator());
            String cloudRegion = Objects.requireNonNull(parameters.getCloudRegion());
            String optCloudType = parameters.getCloudType();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(ConnectionUrlFormat.SNOWFLAKE_URI_PREFIX).append(accountLocator).append(".").append(cloudRegion);
            Optional.ofNullable(optCloudType).ifPresent(cloudType -> stringBuilder.append(".").append((String)cloudType));
            stringBuilder.append(ConnectionUrlFormat.SNOWFLAKE_HOST_SUFFIX);
            return stringBuilder.toString();
        }
    };

    public static final String SNOWFLAKE_HOST_SUFFIX = ".snowflakecomputing.com";
    public static final String SNOWFLAKE_SCHEME = "jdbc:snowflake";
    public static final String SNOWFLAKE_URI_PREFIX = "jdbc:snowflake://";
    private final String value;
    private final String displayName;
    private final String description;

    private ConnectionUrlFormat(String value, String displayName, String description) {
        this.value = value;
        this.displayName = displayName;
        this.description = description;
    }

    public String getValue() {
        return this.value;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public abstract String buildConnectionUrl(ConnectionUrlFormatParameters var1);
}

