/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.snowflake.service;

import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.util.List;
import net.snowflake.ingest.SimpleIngestManager;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnDisabled;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.components.DescribedValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.key.service.api.PrivateKeyService;
import org.apache.nifi.migration.PropertyConfiguration;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.snowflake.SnowflakeIngestManagerProviderService;
import org.apache.nifi.processors.snowflake.util.SnowflakeProperties;
import org.apache.nifi.reporting.InitializationException;
import org.apache.nifi.snowflake.service.util.AccountIdentifierFormat;
import org.apache.nifi.snowflake.service.util.AccountIdentifierFormatParameters;

@Tags(value={"snowflake", "jdbc", "database", "connection"})
@CapabilityDescription(value="Provides a Snowflake Ingest Manager for Snowflake pipe processors")
public class StandardSnowflakeIngestManagerProviderService
extends AbstractControllerService
implements SnowflakeIngestManagerProviderService {
    public static final PropertyDescriptor ACCOUNT_IDENTIFIER_FORMAT = new PropertyDescriptor.Builder().name("Account Identifier Format").description("The format of the account identifier.").addValidator(StandardValidators.NON_BLANK_VALIDATOR).required(true).allowableValues(AccountIdentifierFormat.class).defaultValue((DescribedValue)AccountIdentifierFormat.ACCOUNT_NAME).build();
    public static final PropertyDescriptor HOST_URL = new PropertyDescriptor.Builder().name("Snowflake URL").description("Example host url: [account-locator].[cloud-region].[cloud].snowflakecomputing.com").addValidator(StandardValidators.NON_BLANK_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).required(true).dependsOn(ACCOUNT_IDENTIFIER_FORMAT, (DescribedValue)AccountIdentifierFormat.FULL_URL, new DescribedValue[0]).build();
    public static final PropertyDescriptor ACCOUNT_LOCATOR = new PropertyDescriptor.Builder().fromPropertyDescriptor(SnowflakeProperties.ACCOUNT_LOCATOR).dependsOn(ACCOUNT_IDENTIFIER_FORMAT, (DescribedValue)AccountIdentifierFormat.ACCOUNT_LOCATOR, new DescribedValue[0]).build();
    public static final PropertyDescriptor CLOUD_REGION = new PropertyDescriptor.Builder().fromPropertyDescriptor(SnowflakeProperties.CLOUD_REGION).dependsOn(ACCOUNT_IDENTIFIER_FORMAT, (DescribedValue)AccountIdentifierFormat.ACCOUNT_LOCATOR, new DescribedValue[0]).build();
    public static final PropertyDescriptor CLOUD_TYPE = new PropertyDescriptor.Builder().fromPropertyDescriptor(SnowflakeProperties.CLOUD_TYPE).dependsOn(ACCOUNT_IDENTIFIER_FORMAT, (DescribedValue)AccountIdentifierFormat.ACCOUNT_LOCATOR, new DescribedValue[0]).build();
    public static final PropertyDescriptor ORGANIZATION_NAME = new PropertyDescriptor.Builder().fromPropertyDescriptor(SnowflakeProperties.ORGANIZATION_NAME).dependsOn(ACCOUNT_IDENTIFIER_FORMAT, (DescribedValue)AccountIdentifierFormat.ACCOUNT_NAME, new DescribedValue[0]).build();
    public static final PropertyDescriptor ACCOUNT_NAME = new PropertyDescriptor.Builder().fromPropertyDescriptor(SnowflakeProperties.ACCOUNT_NAME).dependsOn(ACCOUNT_IDENTIFIER_FORMAT, (DescribedValue)AccountIdentifierFormat.ACCOUNT_NAME, new DescribedValue[0]).build();
    public static final PropertyDescriptor USER_NAME = new PropertyDescriptor.Builder().name("User Name").description("The Snowflake user name.").addValidator(StandardValidators.NON_BLANK_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).required(true).build();
    public static final PropertyDescriptor PRIVATE_KEY_SERVICE = new PropertyDescriptor.Builder().name("Private Key Service").description("Specifies the Controller Service that will provide the private key. The public key needs to be added to the user account in the Snowflake account beforehand.").identifiesControllerService(PrivateKeyService.class).required(true).build();
    public static final PropertyDescriptor DATABASE = new PropertyDescriptor.Builder().fromPropertyDescriptor(SnowflakeProperties.DATABASE).required(true).build();
    public static final PropertyDescriptor SCHEMA = new PropertyDescriptor.Builder().fromPropertyDescriptor(SnowflakeProperties.SCHEMA).required(true).build();
    public static final PropertyDescriptor PIPE = new PropertyDescriptor.Builder().name("Pipe").description("The Snowflake pipe to ingest from.").addValidator(StandardValidators.NON_BLANK_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).required(true).build();
    static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS = List.of(ACCOUNT_IDENTIFIER_FORMAT, HOST_URL, ACCOUNT_LOCATOR, CLOUD_REGION, CLOUD_TYPE, ORGANIZATION_NAME, ACCOUNT_NAME, USER_NAME, PRIVATE_KEY_SERVICE, DATABASE, SCHEMA, PIPE);
    private volatile String fullyQualifiedPipeName;
    private volatile SimpleIngestManager ingestManager;

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    @OnEnabled
    public void onEnabled(ConfigurationContext context) throws InitializationException {
        String user = context.getProperty(USER_NAME).evaluateAttributeExpressions().getValue();
        String database = context.getProperty(DATABASE).evaluateAttributeExpressions().getValue();
        String schema = context.getProperty(SCHEMA).evaluateAttributeExpressions().getValue();
        String pipe = context.getProperty(PIPE).evaluateAttributeExpressions().getValue();
        this.fullyQualifiedPipeName = database + "." + schema + "." + pipe;
        PrivateKeyService privateKeyService = (PrivateKeyService)context.getProperty(PRIVATE_KEY_SERVICE).asControllerService(PrivateKeyService.class);
        PrivateKey privateKey = privateKeyService.getPrivateKey();
        AccountIdentifierFormat accountIdentifierFormat = (AccountIdentifierFormat)context.getProperty(ACCOUNT_IDENTIFIER_FORMAT).asAllowableValue(AccountIdentifierFormat.class);
        AccountIdentifierFormatParameters parameters = this.getAccountIdentifierFormatParameters(context);
        String account = accountIdentifierFormat.getAccount(parameters);
        String host = accountIdentifierFormat.getHostname(parameters);
        try {
            this.ingestManager = new SimpleIngestManager(account, user, this.fullyQualifiedPipeName, privateKey, "https", host, 443);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new InitializationException("Failed create Snowflake ingest manager", (Throwable)e);
        }
    }

    @OnDisabled
    public void onDisabled() {
        if (this.ingestManager != null) {
            this.ingestManager.close();
            this.ingestManager = null;
        }
    }

    public String getPipeName() {
        return this.fullyQualifiedPipeName;
    }

    public SimpleIngestManager getIngestManager() {
        return this.ingestManager;
    }

    public void migrateProperties(PropertyConfiguration config) {
        config.renameProperty("account-identifier-format", ACCOUNT_IDENTIFIER_FORMAT.getName());
        config.renameProperty("host-url", HOST_URL.getName());
        config.renameProperty("user-name", USER_NAME.getName());
        config.renameProperty("private-key-service", PRIVATE_KEY_SERVICE.getName());
        config.renameProperty("pipe", PIPE.getName());
        config.renameProperty("account-locator", SnowflakeProperties.ACCOUNT_LOCATOR.getName());
        config.renameProperty("cloud-region", SnowflakeProperties.CLOUD_REGION.getName());
        config.renameProperty("cloud-type", SnowflakeProperties.CLOUD_TYPE.getName());
        config.renameProperty("organization-name", SnowflakeProperties.ORGANIZATION_NAME.getName());
        config.renameProperty("account-name", SnowflakeProperties.ACCOUNT_NAME.getName());
        config.renameProperty("database", SnowflakeProperties.DATABASE.getName());
        config.renameProperty("schema", SnowflakeProperties.SCHEMA.getName());
    }

    private AccountIdentifierFormatParameters getAccountIdentifierFormatParameters(ConfigurationContext context) {
        return new AccountIdentifierFormatParameters(context.getProperty(HOST_URL).evaluateAttributeExpressions().getValue(), context.getProperty(ORGANIZATION_NAME).evaluateAttributeExpressions().getValue(), context.getProperty(ACCOUNT_NAME).evaluateAttributeExpressions().getValue(), context.getProperty(ACCOUNT_LOCATOR).evaluateAttributeExpressions().getValue(), context.getProperty(CLOUD_REGION).evaluateAttributeExpressions().getValue(), context.getProperty(CLOUD_TYPE).evaluateAttributeExpressions().getValue());
    }
}

