/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.snowflake.service;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.snowflake.client.core.SFSessionProperty;
import net.snowflake.client.jdbc.SnowflakeDriver;
import org.apache.nifi.annotation.behavior.DynamicProperties;
import org.apache.nifi.annotation.behavior.DynamicProperty;
import org.apache.nifi.annotation.behavior.RequiresInstanceClassLoading;
import org.apache.nifi.annotation.behavior.SupportsSensitiveDynamicProperties;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnDisabled;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.components.DescribedValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.dbcp.AbstractDBCPConnectionPool;
import org.apache.nifi.dbcp.utils.DBCPProperties;
import org.apache.nifi.dbcp.utils.DataSourceConfiguration;
import org.apache.nifi.expression.AttributeExpression;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.oauth2.OAuth2AccessTokenProvider;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.snowflake.SnowflakeConnectionProviderService;
import org.apache.nifi.processors.snowflake.SnowflakeConnectionWrapper;
import org.apache.nifi.processors.snowflake.util.SnowflakeProperties;
import org.apache.nifi.proxy.ProxyConfiguration;
import org.apache.nifi.proxy.ProxyConfigurationService;
import org.apache.nifi.reporting.InitializationException;
import org.apache.nifi.snowflake.service.util.ConnectionUrlFormat;
import org.apache.nifi.snowflake.service.util.ConnectionUrlFormatParameters;

@Tags(value={"snowflake", "dbcp", "jdbc", "database", "connection", "pooling", "store"})
@CapabilityDescription(value="Provides Snowflake Connection Pooling Service. Connections can be asked from pool and returned after usage.")
@SupportsSensitiveDynamicProperties
@DynamicProperties(value={@DynamicProperty(name="JDBC property name", value="Snowflake JDBC property value", expressionLanguageScope=ExpressionLanguageScope.ENVIRONMENT, description="Snowflake JDBC driver property name and value applied to JDBC connections.")})
@RequiresInstanceClassLoading
public class SnowflakeComputingConnectionPool
extends AbstractDBCPConnectionPool
implements SnowflakeConnectionProviderService {
    public static final PropertyDescriptor CONNECTION_URL_FORMAT = new PropertyDescriptor.Builder().name("connection-url-format").displayName("Connection URL Format").description("The format of the connection URL.").allowableValues(ConnectionUrlFormat.class).required(true).defaultValue((DescribedValue)ConnectionUrlFormat.FULL_URL).build();
    public static final PropertyDescriptor SNOWFLAKE_URL = new PropertyDescriptor.Builder().fromPropertyDescriptor(DBCPProperties.DATABASE_URL).displayName("Snowflake URL").description("Example connection string: jdbc:snowflake://[account].[region].snowflakecomputing.com/?[connection_params] The connection parameters can include db=DATABASE_NAME to avoid using qualified table names such as DATABASE_NAME.PUBLIC.TABLE_NAME").required(true).dependsOn(CONNECTION_URL_FORMAT, (DescribedValue)ConnectionUrlFormat.FULL_URL, new DescribedValue[0]).build();
    public static final PropertyDescriptor SNOWFLAKE_ACCOUNT_LOCATOR = new PropertyDescriptor.Builder().fromPropertyDescriptor(SnowflakeProperties.ACCOUNT_LOCATOR).dependsOn(CONNECTION_URL_FORMAT, (DescribedValue)ConnectionUrlFormat.ACCOUNT_LOCATOR, new DescribedValue[0]).build();
    public static final PropertyDescriptor SNOWFLAKE_CLOUD_REGION = new PropertyDescriptor.Builder().fromPropertyDescriptor(SnowflakeProperties.CLOUD_REGION).dependsOn(CONNECTION_URL_FORMAT, (DescribedValue)ConnectionUrlFormat.ACCOUNT_LOCATOR, new DescribedValue[0]).build();
    public static final PropertyDescriptor SNOWFLAKE_CLOUD_TYPE = new PropertyDescriptor.Builder().fromPropertyDescriptor(SnowflakeProperties.CLOUD_TYPE).dependsOn(CONNECTION_URL_FORMAT, (DescribedValue)ConnectionUrlFormat.ACCOUNT_LOCATOR, new DescribedValue[0]).build();
    public static final PropertyDescriptor SNOWFLAKE_ORGANIZATION_NAME = new PropertyDescriptor.Builder().fromPropertyDescriptor(SnowflakeProperties.ORGANIZATION_NAME).dependsOn(CONNECTION_URL_FORMAT, (DescribedValue)ConnectionUrlFormat.ACCOUNT_NAME, new DescribedValue[0]).build();
    public static final PropertyDescriptor SNOWFLAKE_ACCOUNT_NAME = new PropertyDescriptor.Builder().fromPropertyDescriptor(SnowflakeProperties.ACCOUNT_NAME).dependsOn(CONNECTION_URL_FORMAT, (DescribedValue)ConnectionUrlFormat.ACCOUNT_NAME, new DescribedValue[0]).build();
    public static final PropertyDescriptor SNOWFLAKE_USER = new PropertyDescriptor.Builder().fromPropertyDescriptor(DBCPProperties.DB_USER).displayName("Username").description("The Snowflake user name.").build();
    public static final PropertyDescriptor SNOWFLAKE_PASSWORD = new PropertyDescriptor.Builder().fromPropertyDescriptor(DBCPProperties.DB_PASSWORD).description("The password for the Snowflake user.").build();
    public static final PropertyDescriptor ACCESS_TOKEN_PROVIDER = new PropertyDescriptor.Builder().name("OAuth2 Access Token Provider").description("Service providing OAuth2 Access Tokens for authenticating using the HTTP Authorization Header").identifiesControllerService(OAuth2AccessTokenProvider.class).build();
    public static final PropertyDescriptor SNOWFLAKE_WAREHOUSE = new PropertyDescriptor.Builder().name("warehouse").displayName("Warehouse").description("The warehouse to use by default. The same as passing 'warehouse=WAREHOUSE' to the connection string.").addValidator(StandardValidators.NON_BLANK_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).build();
    private volatile OAuth2AccessTokenProvider accessTokenProvider;
    private static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS = List.of(CONNECTION_URL_FORMAT, SNOWFLAKE_URL, SNOWFLAKE_ACCOUNT_LOCATOR, SNOWFLAKE_CLOUD_REGION, SNOWFLAKE_CLOUD_TYPE, SNOWFLAKE_ORGANIZATION_NAME, SNOWFLAKE_ACCOUNT_NAME, SNOWFLAKE_USER, SNOWFLAKE_PASSWORD, SnowflakeProperties.DATABASE, SnowflakeProperties.SCHEMA, SNOWFLAKE_WAREHOUSE, ACCESS_TOKEN_PROVIDER, ProxyConfigurationService.PROXY_CONFIGURATION_SERVICE, DBCPProperties.VALIDATION_QUERY, DBCPProperties.MAX_WAIT_TIME, DBCPProperties.MAX_TOTAL_CONNECTIONS, DBCPProperties.MIN_IDLE, DBCPProperties.MAX_IDLE, DBCPProperties.MAX_CONN_LIFETIME, DBCPProperties.EVICTION_RUN_PERIOD, DBCPProperties.MIN_EVICTABLE_IDLE_TIME, DBCPProperties.SOFT_MIN_EVICTABLE_IDLE_TIME);

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    protected PropertyDescriptor getSupportedDynamicPropertyDescriptor(String propertyDescriptorName) {
        PropertyDescriptor.Builder builder = new PropertyDescriptor.Builder().name(propertyDescriptorName).required(false).dynamic(true).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).addValidator(StandardValidators.createAttributeExpressionLanguageValidator((AttributeExpression.ResultType)AttributeExpression.ResultType.STRING, (boolean)true)).addValidator(StandardValidators.ATTRIBUTE_KEY_PROPERTY_NAME_VALIDATOR);
        return builder.build();
    }

    protected Collection<ValidationResult> customValidate(ValidationContext context) {
        return Collections.emptyList();
    }

    @OnEnabled
    public void onConfigured(ConfigurationContext context) throws InitializationException {
        super.onConfigured(context);
        this.accessTokenProvider = (OAuth2AccessTokenProvider)context.getProperty(ACCESS_TOKEN_PROVIDER).asControllerService(OAuth2AccessTokenProvider.class);
    }

    @OnDisabled
    public void onDisabled() {
        this.accessTokenProvider = null;
    }

    private void refreshAccessToken() {
        if (this.accessTokenProvider != null) {
            this.dataSource.addConnectionProperty(SFSessionProperty.TOKEN.getPropertyKey(), this.accessTokenProvider.getAccessDetails().getAccessToken());
        }
    }

    protected DataSourceConfiguration getDataSourceConfiguration(ConfigurationContext context) {
        String url = this.getUrl(context);
        String driverName = SnowflakeDriver.class.getName();
        String user = context.getProperty(DBCPProperties.DB_USER).evaluateAttributeExpressions().getValue();
        String password = context.getProperty(DBCPProperties.DB_PASSWORD).evaluateAttributeExpressions().getValue();
        Integer maxTotal = context.getProperty(DBCPProperties.MAX_TOTAL_CONNECTIONS).evaluateAttributeExpressions().asInteger();
        String validationQuery = context.getProperty(DBCPProperties.VALIDATION_QUERY).evaluateAttributeExpressions().getValue();
        Long maxWaitMillis = DBCPProperties.extractMillisWithInfinite((PropertyValue)context.getProperty(DBCPProperties.MAX_WAIT_TIME).evaluateAttributeExpressions());
        Integer minIdle = context.getProperty(DBCPProperties.MIN_IDLE).evaluateAttributeExpressions().asInteger();
        Integer maxIdle = context.getProperty(DBCPProperties.MAX_IDLE).evaluateAttributeExpressions().asInteger();
        Long maxConnLifetimeMillis = DBCPProperties.extractMillisWithInfinite((PropertyValue)context.getProperty(DBCPProperties.MAX_CONN_LIFETIME).evaluateAttributeExpressions());
        Long timeBetweenEvictionRunsMillis = DBCPProperties.extractMillisWithInfinite((PropertyValue)context.getProperty(DBCPProperties.EVICTION_RUN_PERIOD).evaluateAttributeExpressions());
        Long minEvictableIdleTimeMillis = DBCPProperties.extractMillisWithInfinite((PropertyValue)context.getProperty(DBCPProperties.MIN_EVICTABLE_IDLE_TIME).evaluateAttributeExpressions());
        Long softMinEvictableIdleTimeMillis = DBCPProperties.extractMillisWithInfinite((PropertyValue)context.getProperty(DBCPProperties.SOFT_MIN_EVICTABLE_IDLE_TIME).evaluateAttributeExpressions());
        return new DataSourceConfiguration.Builder(url, driverName, user, password).maxTotal(maxTotal.intValue()).validationQuery(validationQuery).maxWaitMillis(maxWaitMillis.longValue()).minIdle(minIdle.intValue()).maxIdle(maxIdle.intValue()).maxConnLifetimeMillis(maxConnLifetimeMillis.longValue()).timeBetweenEvictionRunsMillis(timeBetweenEvictionRunsMillis.longValue()).minEvictableIdleTimeMillis(minEvictableIdleTimeMillis.longValue()).softMinEvictableIdleTimeMillis(softMinEvictableIdleTimeMillis.longValue()).build();
    }

    protected String getUrl(ConfigurationContext context) {
        ConnectionUrlFormat connectionUrlFormat = (ConnectionUrlFormat)context.getProperty(CONNECTION_URL_FORMAT).asAllowableValue(ConnectionUrlFormat.class);
        ConnectionUrlFormatParameters parameters = this.getConnectionUrlFormatParameters(context);
        return connectionUrlFormat.buildConnectionUrl(parameters);
    }

    protected Driver getDriver(String driverName, String url) {
        try {
            Class.forName(driverName);
            return DriverManager.getDriver(url);
        }
        catch (Exception e) {
            throw new ProcessException("Snowflake driver unavailable or incompatible connection URL", (Throwable)e);
        }
    }

    protected Map<String, String> getConnectionProperties(ConfigurationContext context) {
        ProxyConfigurationService proxyConfigurationService;
        String database = context.getProperty(SnowflakeProperties.DATABASE).evaluateAttributeExpressions().getValue();
        String schema = context.getProperty(SnowflakeProperties.SCHEMA).evaluateAttributeExpressions().getValue();
        String warehouse = context.getProperty(SNOWFLAKE_WAREHOUSE).evaluateAttributeExpressions().getValue();
        OAuth2AccessTokenProvider tokenProvider = (OAuth2AccessTokenProvider)context.getProperty(ACCESS_TOKEN_PROVIDER).asControllerService(OAuth2AccessTokenProvider.class);
        Map connectionProperties = super.getConnectionProperties(context);
        if (database != null) {
            connectionProperties.put("db", database);
        }
        if (schema != null) {
            connectionProperties.put("schema", schema);
        }
        if (warehouse != null) {
            connectionProperties.put("warehouse", warehouse);
        }
        if (tokenProvider != null) {
            connectionProperties.put(SFSessionProperty.AUTHENTICATOR.getPropertyKey(), "oauth");
            connectionProperties.put(SFSessionProperty.TOKEN.getPropertyKey(), tokenProvider.getAccessDetails().getAccessToken());
        }
        if ((proxyConfigurationService = (ProxyConfigurationService)context.getProperty(ProxyConfigurationService.PROXY_CONFIGURATION_SERVICE).asControllerService(ProxyConfigurationService.class)) != null) {
            ProxyConfiguration proxyConfiguration = proxyConfigurationService.getConfiguration();
            connectionProperties.put(SFSessionProperty.USE_PROXY.getPropertyKey(), "true");
            if (proxyConfiguration.getProxyServerHost() != null) {
                connectionProperties.put(SFSessionProperty.PROXY_HOST.getPropertyKey(), proxyConfiguration.getProxyServerHost());
            }
            if (proxyConfiguration.getProxyServerPort() != null) {
                connectionProperties.put(SFSessionProperty.PROXY_PORT.getPropertyKey(), proxyConfiguration.getProxyServerPort().toString());
            }
            if (proxyConfiguration.getProxyUserName() != null) {
                connectionProperties.put(SFSessionProperty.PROXY_USER.getPropertyKey(), proxyConfiguration.getProxyUserName());
            }
            if (proxyConfiguration.getProxyUserPassword() != null) {
                connectionProperties.put(SFSessionProperty.PROXY_PASSWORD.getPropertyKey(), proxyConfiguration.getProxyUserPassword());
            }
            if (proxyConfiguration.getProxyType() != null) {
                connectionProperties.put(SFSessionProperty.PROXY_PROTOCOL.getPropertyKey(), proxyConfiguration.getProxyType().name().toLowerCase());
            }
        }
        return connectionProperties;
    }

    public Connection getConnection() throws ProcessException {
        this.refreshAccessToken();
        return super.getConnection();
    }

    public SnowflakeConnectionWrapper getSnowflakeConnection() {
        return new SnowflakeConnectionWrapper(this.getConnection());
    }

    private ConnectionUrlFormatParameters getConnectionUrlFormatParameters(ConfigurationContext context) {
        return new ConnectionUrlFormatParameters(context.getProperty(SNOWFLAKE_URL).evaluateAttributeExpressions().getValue(), context.getProperty(SNOWFLAKE_ORGANIZATION_NAME).evaluateAttributeExpressions().getValue(), context.getProperty(SNOWFLAKE_ACCOUNT_NAME).evaluateAttributeExpressions().getValue(), context.getProperty(SNOWFLAKE_ACCOUNT_LOCATOR).evaluateAttributeExpressions().getValue(), context.getProperty(SNOWFLAKE_CLOUD_REGION).evaluateAttributeExpressions().getValue(), context.getProperty(SNOWFLAKE_CLOUD_TYPE).evaluateAttributeExpressions().getValue());
    }
}

