/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.snowflake.util;

import java.util.Objects;
import java.util.Optional;
import org.apache.nifi.components.DescribedValue;
import org.apache.nifi.processors.snowflake.util.SnowflakeInternalStageTypeParameters;

public enum SnowflakeInternalStageType implements DescribedValue
{
    USER("user", "User", "Use the user's internal stage"){

        @Override
        public String getStage(SnowflakeInternalStageTypeParameters parameters) {
            return "@~";
        }
    }
    ,
    TABLE("table", "Table", "Use a table's internal stage"){

        @Override
        public String getStage(SnowflakeInternalStageTypeParameters parameters) {
            StringBuilder stringBuilder = new StringBuilder("@");
            Optional.ofNullable(parameters.database()).ifPresent(database -> stringBuilder.append((String)database).append("."));
            Optional.ofNullable(parameters.schema()).ifPresent(schema -> stringBuilder.append((String)schema).append("."));
            stringBuilder.append("%").append(Objects.requireNonNull(parameters.table()));
            return stringBuilder.toString();
        }
    }
    ,
    NAMED("named", "Named", "Use a named internal stage. This stage must be created beforehand in Snowflake"){

        @Override
        public String getStage(SnowflakeInternalStageTypeParameters parameters) {
            StringBuilder stringBuilder = new StringBuilder("@");
            Optional.ofNullable(parameters.database()).ifPresent(database -> stringBuilder.append((String)database).append("."));
            Optional.ofNullable(parameters.schema()).ifPresent(schema -> stringBuilder.append((String)schema).append("."));
            stringBuilder.append(Objects.requireNonNull(parameters.stageName()));
            return stringBuilder.toString();
        }
    };

    private final String value;
    private final String displayName;
    private final String description;

    private SnowflakeInternalStageType(String value, String displayName, String description) {
        this.value = value;
        this.displayName = displayName;
        this.description = description;
    }

    public String getValue() {
        return this.value;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public abstract String getStage(SnowflakeInternalStageTypeParameters var1);
}

