/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.snmp.configuration;

import org.apache.nifi.util.StringUtils;

public class V1TrapConfiguration {
    static final String ENTERPRISE_OID_MUST_BE_SPECIFIED = "Enterprise OID must be specified.";
    static final String AGENT_ADDRESS_MUST_BE_SPECIFIED = "Agent address must be specified.";
    public static final String GENERIC_TRAP_TYPE_MUST_BE_BETWEEN_0_AND_6 = "Generic Trap Type must be between 0 and 6.";
    public static final String GENERIC_TRAP_TYPE_IS_NOT_A_NUMBER = "Generic Trap Type is not a number.";
    public static final String SPECIFIC_TRAP_TYPE_MUST_BE_BETWEEN_0_AND_2147483647 = "Specific Trap Type must be between 0 and 2147483647.";
    public static final String GENERIC_TRAP_TYPE_IS_6_ENTERPRISE_SPECIFIC_BUT_SPECIFIC_TRAP_TYPE_IS_NOT_PROVIDED = "Generic Trap Type is [6 - Enterprise Specific] but Specific Trap Type is not provided or not a number.";
    private final String enterpriseOid;
    private final String agentAddress;
    private final String genericTrapType;
    private final String specificTrapType;

    private V1TrapConfiguration(Builder builder) {
        this.enterpriseOid = builder.enterpriseOid;
        this.agentAddress = builder.agentAddress;
        this.genericTrapType = builder.genericTrapType;
        this.specificTrapType = builder.specificTrapType;
    }

    public String getEnterpriseOid() {
        return this.enterpriseOid;
    }

    public String getAgentAddress() {
        return this.agentAddress;
    }

    public int getGenericTrapType() {
        return Integer.parseInt(this.genericTrapType);
    }

    public Integer getSpecificTrapType() {
        if (StringUtils.isNotEmpty((String)this.specificTrapType)) {
            return Integer.parseInt(this.specificTrapType);
        }
        return null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        String enterpriseOid;
        String agentAddress;
        String genericTrapType;
        String specificTrapType;

        public Builder enterpriseOid(String enterpriseOid) {
            this.enterpriseOid = enterpriseOid;
            return this;
        }

        public Builder agentAddress(String agentAddress) {
            this.agentAddress = agentAddress;
            return this;
        }

        public Builder genericTrapType(String genericTrapType) {
            this.genericTrapType = genericTrapType;
            return this;
        }

        public Builder specificTrapType(String specificTrapType) {
            this.specificTrapType = specificTrapType;
            return this;
        }

        public V1TrapConfiguration build() {
            int parsedGenericTrapType;
            if (StringUtils.isEmpty((String)this.enterpriseOid)) {
                throw new IllegalArgumentException(V1TrapConfiguration.ENTERPRISE_OID_MUST_BE_SPECIFIED);
            }
            if (StringUtils.isEmpty((String)this.agentAddress)) {
                throw new IllegalArgumentException(V1TrapConfiguration.AGENT_ADDRESS_MUST_BE_SPECIFIED);
            }
            try {
                parsedGenericTrapType = Integer.parseInt(this.genericTrapType);
                if (parsedGenericTrapType < 0 || parsedGenericTrapType > 6) {
                    throw new IllegalArgumentException(V1TrapConfiguration.GENERIC_TRAP_TYPE_MUST_BE_BETWEEN_0_AND_6);
                }
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(V1TrapConfiguration.GENERIC_TRAP_TYPE_IS_NOT_A_NUMBER);
            }
            if (parsedGenericTrapType == 6) {
                try {
                    int parsedSpecificTrapType = Integer.parseInt(this.specificTrapType);
                    if (parsedSpecificTrapType < 0) {
                        throw new IllegalArgumentException(V1TrapConfiguration.SPECIFIC_TRAP_TYPE_MUST_BE_BETWEEN_0_AND_2147483647);
                    }
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException(V1TrapConfiguration.GENERIC_TRAP_TYPE_IS_6_ENTERPRISE_SPECIFIC_BUT_SPECIFIC_TRAP_TYPE_IS_NOT_PROVIDED);
                }
            }
            return new V1TrapConfiguration(this);
        }
    }
}

