/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.snmp.processors;

import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import org.apache.nifi.annotation.behavior.RequiresInstanceClassLoading;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.annotation.lifecycle.OnStopped;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.migration.PropertyConfiguration;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.snmp.configuration.SNMPConfiguration;
import org.apache.nifi.snmp.dto.ErrorStatus;
import org.apache.nifi.snmp.dto.SNMPResponseStatus;
import org.apache.nifi.snmp.dto.SNMPSingleResponse;
import org.apache.nifi.snmp.dto.SNMPValue;
import org.apache.nifi.snmp.factory.core.SNMPContext;
import org.apache.nifi.snmp.factory.core.SNMPFactoryProvider;
import org.apache.nifi.snmp.logging.SLF4JLogFactory;
import org.apache.nifi.snmp.processors.properties.BasicProperties;
import org.apache.nifi.snmp.processors.properties.V3SecurityProperties;
import org.apache.nifi.snmp.utils.SNMPUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.snmp4j.Snmp;
import org.snmp4j.log.LogFactory;
import org.snmp4j.security.SecurityModels;
import org.snmp4j.smi.Integer32;

@RequiresInstanceClassLoading
public abstract class AbstractSNMPProcessor
extends AbstractProcessor {
    private static final Logger logger = LoggerFactory.getLogger(AbstractSNMPProcessor.class);
    public static final String REQUEST_TIMEOUT_EXCEPTION_TEMPLATE = "Request timed out. Please check if (1). the agent host and port is correctly set, (2). the agent is running, (3). the agent SNMP version corresponds with the processor's one, (4) the community string is correct and has %1$s access, (5) In case of SNMPv3 check if the user credentials are valid and the user in a group with %1$s access.";
    private static final String NO_SUCH_OBJECT = "noSuchObject";
    public static final PropertyDescriptor AGENT_HOST;
    public static final PropertyDescriptor AGENT_PORT;
    protected volatile Snmp snmpManager;
    protected volatile SNMPContext factory;

    @OnScheduled
    public void initSnmpManager(ProcessContext context) {
        String snmpVersion = context.getProperty(BasicProperties.SNMP_VERSION).getValue();
        String securityLevel = AbstractSNMPProcessor.getSecurityLevel(context, snmpVersion);
        SNMPConfiguration configuration = SNMPConfiguration.builder().setAuthProtocol(AbstractSNMPProcessor.getAuthProtocol(context, securityLevel)).setAuthPassphrase(AbstractSNMPProcessor.getAuthPassphrase(context, securityLevel)).setPrivacyProtocol(AbstractSNMPProcessor.getPrivacyProtocol(context, securityLevel)).setPrivacyPassphrase(AbstractSNMPProcessor.getPrivacyPassphrase(context, securityLevel)).setSecurityName(AbstractSNMPProcessor.getSecurityName(context, snmpVersion)).build();
        this.factory = SNMPFactoryProvider.getFactory(SNMPUtils.getVersion(snmpVersion));
        this.snmpManager = this.factory.createSnmpManagerInstance(configuration);
    }

    protected SNMPConfiguration getTargetConfiguration(ProcessContext context, FlowFile flowFile) {
        String snmpVersion = context.getProperty(BasicProperties.SNMP_VERSION).getValue();
        return SNMPConfiguration.builder().setVersion(SNMPUtils.getVersion(snmpVersion)).setTargetHost(this.getTargetHost(context, flowFile)).setTargetPort(this.getTargetPort(context, flowFile)).setRetries(context.getProperty(BasicProperties.SNMP_RETRIES).asInteger()).setTimeoutInMs(context.getProperty(BasicProperties.SNMP_TIMEOUT).asInteger().intValue()).setSecurityName(AbstractSNMPProcessor.getSecurityName(context, snmpVersion)).setSecurityLevel(AbstractSNMPProcessor.getSecurityLevel(context, snmpVersion)).setCommunityString(AbstractSNMPProcessor.getCommunity(context, snmpVersion)).build();
    }

    @OnStopped
    public void close() {
        try {
            if (this.snmpManager.getUSM() != null) {
                this.snmpManager.getUSM().removeAllUsers();
                SecurityModels.getInstance().removeSecurityModel(new Integer32(this.snmpManager.getUSM().getID()));
            }
            this.snmpManager.close();
        }
        catch (IOException e) {
            String errorMessage = "Could not close SNMP manager.";
            logger.error("Could not close SNMP manager.", (Throwable)e);
            throw new ProcessException("Could not close SNMP manager.");
        }
    }

    protected void handleResponse(ProcessContext context, ProcessSession processSession, FlowFile flowFile, SNMPSingleResponse response, Relationship success, Relationship failure, String provenanceAddress, boolean isNewFlowFileCreated) {
        SNMPResponseStatus snmpResponseStatus = this.processResponse(response);
        processSession.putAllAttributes(flowFile, response.getAttributes());
        if (snmpResponseStatus.getErrorStatus() == ErrorStatus.FAILURE) {
            this.getLogger().error("SNMP request failed, response error: {}", new Object[]{snmpResponseStatus.getErrorMessage()});
            processSession.transfer(flowFile, failure);
            context.yield();
        } else {
            if (isNewFlowFileCreated) {
                processSession.getProvenanceReporter().receive(flowFile, response.getTargetAddress() + provenanceAddress);
            } else {
                processSession.getProvenanceReporter().fetch(flowFile, response.getTargetAddress() + provenanceAddress);
            }
            processSession.transfer(flowFile, success);
        }
    }

    protected SNMPResponseStatus processResponse(SNMPSingleResponse response) {
        if (response.isValid()) {
            if (response.isReportPdu()) {
                String oid = response.getVariableBindings().get(0).getOid();
                Optional<String> reportPduErrorMessage = SNMPUtils.getErrorMessage(oid);
                if (!reportPduErrorMessage.isPresent()) {
                    return new SNMPResponseStatus(String.format("Report-PDU returned, but no error message found. Please, check the OID %s in an online OID repository.", oid), ErrorStatus.FAILURE);
                }
                return new SNMPResponseStatus("Report-PDU returned. " + reportPduErrorMessage.get(), ErrorStatus.FAILURE);
            }
            return this.checkV2cV3VariableBindings(response);
        }
        String errorMessage = response.getErrorStatusText();
        return new SNMPResponseStatus(errorMessage, ErrorStatus.FAILURE);
    }

    private SNMPResponseStatus checkV2cV3VariableBindings(SNMPSingleResponse response) {
        if (response.getVersion() == 1 || response.getVersion() == 3) {
            Optional firstVariableBinding = response.getVariableBindings().stream().findFirst();
            if (firstVariableBinding.isPresent()) {
                String value = ((SNMPValue)firstVariableBinding.get()).getVariable();
                if (NO_SUCH_OBJECT.equals(value)) {
                    return new SNMPResponseStatus("OID not found.", ErrorStatus.FAILURE);
                }
            } else {
                return new SNMPResponseStatus("Empty SNMP response: no variable binding found.", ErrorStatus.FAILURE);
            }
        }
        return new SNMPResponseStatus("Successful SNMP Response", ErrorStatus.SUCCESS);
    }

    protected abstract String getTargetHost(ProcessContext var1, FlowFile var2);

    protected abstract String getTargetPort(ProcessContext var1, FlowFile var2);

    public static String getSecurityName(ProcessContext context, String snmpVersion) {
        return snmpVersion.equals(BasicProperties.SNMP_V3.getValue()) ? context.getProperty(V3SecurityProperties.SNMP_SECURITY_NAME).getValue() : null;
    }

    public static String getPrivacyPassphrase(ProcessContext context, String securityLevel) {
        return Objects.equals(securityLevel, V3SecurityProperties.AUTH_PRIV.getValue()) ? context.getProperty(V3SecurityProperties.SNMP_PRIVACY_PASSWORD).getValue() : null;
    }

    public static String getPrivacyProtocol(ProcessContext context, String securityLevel) {
        return Objects.equals(securityLevel, V3SecurityProperties.AUTH_PRIV.getValue()) ? context.getProperty(V3SecurityProperties.SNMP_PRIVACY_PROTOCOL).getValue() : null;
    }

    public static String getAuthPassphrase(ProcessContext context, String securityLevel) {
        return Objects.equals(securityLevel, V3SecurityProperties.AUTH_NO_PRIV.getValue()) || Objects.equals(securityLevel, V3SecurityProperties.AUTH_PRIV.getValue()) ? context.getProperty(V3SecurityProperties.SNMP_AUTH_PASSWORD).getValue() : null;
    }

    public static String getAuthProtocol(ProcessContext context, String securityLevel) {
        return Objects.equals(securityLevel, V3SecurityProperties.AUTH_NO_PRIV.getValue()) || Objects.equals(securityLevel, V3SecurityProperties.AUTH_PRIV.getValue()) ? context.getProperty(V3SecurityProperties.SNMP_AUTH_PROTOCOL).getValue() : null;
    }

    public static String getCommunity(ProcessContext context, String snmpVersion) {
        return snmpVersion.equals(BasicProperties.SNMP_V1.getValue()) || snmpVersion.equals(BasicProperties.SNMP_V2C.getValue()) ? context.getProperty(BasicProperties.SNMP_COMMUNITY).getValue() : null;
    }

    public static String getSecurityLevel(ProcessContext context, String snmpVersion) {
        return snmpVersion.equals(BasicProperties.SNMP_V3.getValue()) ? context.getProperty(V3SecurityProperties.SNMP_SECURITY_LEVEL).getValue() : null;
    }

    public void migrateProperties(PropertyConfiguration config) {
        config.renameProperty("snmp-hostname", AGENT_HOST.getName());
        config.renameProperty("snmp-port", AGENT_PORT.getName());
    }

    static {
        LogFactory.setLogFactory((LogFactory)new SLF4JLogFactory());
        AGENT_HOST = new PropertyDescriptor.Builder().name("SNMP Agent Hostname").description("Hostname or network address of the SNMP Agent.").required(true).defaultValue("localhost").addValidator(StandardValidators.NON_EMPTY_EL_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
        AGENT_PORT = new PropertyDescriptor.Builder().name("SNMP Agent Port").description("Port of the SNMP Agent.").required(true).defaultValue("161").addValidator(StandardValidators.NON_EMPTY_EL_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
    }
}

