/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.snmp.dto;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.snmp.utils.SNMPUtils;
import org.snmp4j.Target;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.util.RetrievalEvent;
import org.snmp4j.util.TreeEvent;

public class SNMPTreeResponse {
    private final Target target;
    private final List<TreeEvent> events;

    public SNMPTreeResponse(Target target, List<TreeEvent> events) {
        this.target = target;
        this.events = events;
    }

    public Map<String, String> getAttributes() {
        List<VariableBinding> variableBindings = this.events.stream().map(TreeEvent::getVariableBindings).filter(Objects::nonNull).flatMap(Arrays::stream).collect(Collectors.toList());
        return SNMPUtils.createWalkOidValuesMap(variableBindings);
    }

    public String getTargetAddress() {
        return this.target.getAddress().toString();
    }

    public void logErrors(ComponentLog logger) {
        this.events.stream().filter(RetrievalEvent::isError).forEach(event -> logger.error("Error occured in SNMP walk event: {}", new Object[]{event.getErrorMessage()}));
    }

    public boolean isError() {
        Optional<TreeEvent> first = this.events.stream().filter(RetrievalEvent::isError).findFirst();
        return first.isPresent();
    }
}

