/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.snmp.dto;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.nifi.snmp.dto.SNMPValue;
import org.apache.nifi.snmp.utils.SNMPUtils;
import org.snmp4j.PDU;
import org.snmp4j.Target;

public class SNMPSingleResponse {
    private final Target target;
    private final PDU responsePdu;

    public SNMPSingleResponse(Target target, PDU responsePdu) {
        this.target = target;
        this.responsePdu = responsePdu;
    }

    public boolean isValid() {
        return this.responsePdu.getErrorStatus() == 0;
    }

    public Map<String, String> getAttributes() {
        return SNMPUtils.getPduAttributeMap(this.responsePdu);
    }

    public List<SNMPValue> getVariableBindings() {
        return this.responsePdu.getVariableBindings().stream().map(p -> new SNMPValue(p.getOid().toString(), p.getVariable().toString())).collect(Collectors.toList());
    }

    public String getErrorStatusText() {
        return this.responsePdu.getErrorStatusText();
    }

    public String getTargetAddress() {
        return this.target.getAddress().toString();
    }

    public int getVersion() {
        return this.target.getVersion();
    }

    public boolean isReportPdu() {
        return this.responsePdu.getType() == -88;
    }
}

