/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.snmp.processors;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.RequiresInstanceClassLoading;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.annotation.lifecycle.OnStopped;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.ConfigVerificationResult;
import org.apache.nifi.components.DescribedValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.Validator;
import org.apache.nifi.components.resource.ResourceCardinality;
import org.apache.nifi.components.resource.ResourceType;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.AbstractSessionFactoryProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSessionFactory;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.VerifiableProcessor;
import org.apache.nifi.processor.util.JsonValidator;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.snmp.configuration.SNMPConfiguration;
import org.apache.nifi.snmp.operations.SNMPTrapReceiverHandler;
import org.apache.nifi.snmp.processors.AbstractSNMPProcessor;
import org.apache.nifi.snmp.processors.properties.BasicProperties;
import org.apache.nifi.snmp.processors.properties.UsmUserInputMethod;
import org.apache.nifi.snmp.processors.properties.V3SecurityProperties;
import org.apache.nifi.snmp.utils.JsonFileUsmReader;
import org.apache.nifi.snmp.utils.JsonUsmReader;
import org.apache.nifi.snmp.utils.SNMPUtils;
import org.apache.nifi.snmp.utils.SecurityNamesUsmReader;
import org.apache.nifi.snmp.utils.UsmReader;
import org.snmp4j.security.UsmUser;

@Tags(value={"snmp", "listen", "trap"})
@InputRequirement(value=InputRequirement.Requirement.INPUT_FORBIDDEN)
@CapabilityDescription(value="Receives information from SNMP Agent and outputs a FlowFile with information in attributes and without any content")
@WritesAttribute(attribute="snmp$*", description="Attributes retrieved from the SNMP response. It may include: snmp$errorIndex, snmp$errorStatus, snmp$errorStatusText, snmp$nonRepeaters, snmp$requestID, snmp$type, snmp$variableBindings")
@RequiresInstanceClassLoading
public class ListenTrapSNMP
extends AbstractSessionFactoryProcessor
implements VerifiableProcessor {
    public static final PropertyDescriptor SNMP_MANAGER_PORT = new PropertyDescriptor.Builder().name("snmp-manager-port").displayName("SNMP Manager Port").description("The port where the SNMP Manager listens to the incoming traps.").required(true).addValidator(StandardValidators.PORT_VALIDATOR).build();
    public static final PropertyDescriptor SNMP_USM_USER_INPUT_METHOD = new PropertyDescriptor.Builder().name("snmp-usm-users-source").displayName("USM Users Input Method").description("Specifies how USM user data is provided.").required(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).allowableValues(UsmUserInputMethod.class).dependsOn(BasicProperties.SNMP_VERSION, new AllowableValue[]{BasicProperties.SNMP_V3}).build();
    public static final PropertyDescriptor SNMP_USM_USERS_JSON_FILE_PATH = new PropertyDescriptor.Builder().name("snmp-usm-users-file-path").displayName("USM Users JSON File Path").description("The path of the json file containing the user credentials for SNMPv3. Check Usage for more details.").required(false).identifiesExternalResource(ResourceCardinality.SINGLE, ResourceType.FILE, new ResourceType[0]).dependsOn(BasicProperties.SNMP_VERSION, new AllowableValue[]{BasicProperties.SNMP_V3}).dependsOn(SNMP_USM_USER_INPUT_METHOD, (DescribedValue)UsmUserInputMethod.USM_JSON_FILE_PATH, new DescribedValue[0]).build();
    public static final PropertyDescriptor SNMP_USM_USERS_JSON = new PropertyDescriptor.Builder().name("snmp-usm-users-json-content").displayName("USM Users JSON content").description("The JSON containing the user credentials for SNMPv3. Check Usage for more details.").required(false).sensitive(true).dependsOn(BasicProperties.SNMP_VERSION, new AllowableValue[]{BasicProperties.SNMP_V3}).dependsOn(SNMP_USM_USER_INPUT_METHOD, (DescribedValue)UsmUserInputMethod.USM_JSON_CONTENT, new DescribedValue[0]).addValidator((Validator)JsonValidator.INSTANCE).build();
    public static final PropertyDescriptor SNMP_USM_SECURITY_NAMES = new PropertyDescriptor.Builder().name("snmp-usm-security-names").displayName("SNMP Users Security Names").description("Security names listed separated by commas in SNMPv3. Check Usage for more details.").required(false).dependsOn(BasicProperties.SNMP_VERSION, new AllowableValue[]{BasicProperties.SNMP_V3}).dependsOn(V3SecurityProperties.SNMP_SECURITY_LEVEL, new AllowableValue[]{V3SecurityProperties.NO_AUTH_NO_PRIV}).dependsOn(SNMP_USM_USER_INPUT_METHOD, (DescribedValue)UsmUserInputMethod.USM_SECURITY_NAMES, new DescribedValue[0]).addValidator(StandardValidators.NON_BLANK_VALIDATOR).build();
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("All FlowFiles that are received from the SNMP agent are routed to this relationship").build();
    public static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("All FlowFiles that cannot received from the SNMP agent are routed to this relationship").build();
    protected static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS = List.of(SNMP_MANAGER_PORT, BasicProperties.SNMP_VERSION, BasicProperties.SNMP_COMMUNITY, V3SecurityProperties.SNMP_SECURITY_LEVEL, SNMP_USM_USER_INPUT_METHOD, SNMP_USM_USERS_JSON_FILE_PATH, SNMP_USM_USERS_JSON, SNMP_USM_SECURITY_NAMES);
    private static final Set<Relationship> RELATIONSHIPS = Set.of(REL_SUCCESS, REL_FAILURE);
    private volatile SNMPTrapReceiverHandler snmpTrapReceiverHandler;
    private volatile List<UsmUser> usmUsers;

    public List<ConfigVerificationResult> verify(ProcessContext context, ComponentLog verificationLogger, Map<String, String> attributes) {
        ArrayList<ConfigVerificationResult> results = new ArrayList<ConfigVerificationResult>();
        String snmpVersion = context.getProperty(BasicProperties.SNMP_VERSION).getValue();
        if (snmpVersion.equals(BasicProperties.SNMP_V3.getValue())) {
            UsmUserInputMethod usmUserInputMethod = (UsmUserInputMethod)context.getProperty(SNMP_USM_USER_INPUT_METHOD).asAllowableValue(UsmUserInputMethod.class);
            try {
                this.getUsmReader(context, usmUserInputMethod).readUsm();
            }
            catch (Exception e) {
                results.add(new ConfigVerificationResult.Builder().verificationStepName("USM User processing").outcome(ConfigVerificationResult.Outcome.FAILED).explanation(e.getMessage() + " " + e.getCause().getMessage()).build());
            }
        }
        return results;
    }

    @OnScheduled
    public void initSnmpManager(ProcessContext context) {
        String snmpVersion = context.getProperty(BasicProperties.SNMP_VERSION).getValue();
        String securityLevel = AbstractSNMPProcessor.getSecurityLevel(context, snmpVersion);
        SNMPConfiguration configuration = SNMPConfiguration.builder().setManagerPort(context.getProperty(SNMP_MANAGER_PORT).asInteger()).setVersion(SNMPUtils.getVersion(snmpVersion)).setSecurityLevel(securityLevel).setCommunityString(AbstractSNMPProcessor.getCommunity(context, snmpVersion)).build();
        if (snmpVersion.equals(BasicProperties.SNMP_V3.getValue())) {
            UsmUserInputMethod usmUserInputMethod = (UsmUserInputMethod)context.getProperty(SNMP_USM_USER_INPUT_METHOD).asAllowableValue(UsmUserInputMethod.class);
            this.usmUsers = this.getUsmReader(context, usmUserInputMethod).readUsm();
        }
        this.snmpTrapReceiverHandler = new SNMPTrapReceiverHandler(configuration, this.usmUsers);
    }

    public int getListeningPort() {
        if (this.snmpTrapReceiverHandler == null || !this.snmpTrapReceiverHandler.isStarted()) {
            return 0;
        }
        return this.snmpTrapReceiverHandler.getListeningPort();
    }

    public void onTrigger(ProcessContext context, ProcessSessionFactory processSessionFactory) {
        if (!this.snmpTrapReceiverHandler.isStarted()) {
            this.snmpTrapReceiverHandler.createTrapReceiver(processSessionFactory, this.getLogger());
        }
        context.yield();
    }

    @OnStopped
    public void close() {
        if (this.snmpTrapReceiverHandler != null) {
            this.snmpTrapReceiverHandler.close();
        }
    }

    public Set<Relationship> getRelationships() {
        return RELATIONSHIPS;
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    private UsmReader getUsmReader(ProcessContext context, UsmUserInputMethod usmUserInputMethod) {
        return switch (usmUserInputMethod) {
            default -> throw new MatchException(null, null);
            case UsmUserInputMethod.USM_JSON_FILE_PATH -> new JsonFileUsmReader(context.getProperty(SNMP_USM_USERS_JSON_FILE_PATH).getValue());
            case UsmUserInputMethod.USM_JSON_CONTENT -> new JsonUsmReader(context.getProperty(SNMP_USM_USERS_JSON).getValue());
            case UsmUserInputMethod.USM_SECURITY_NAMES -> new SecurityNamesUsmReader(context.getProperty(SNMP_USM_SECURITY_NAMES).getValue());
        };
    }
}

