/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.snmp.factory.core;

import org.apache.nifi.snmp.configuration.SNMPConfiguration;
import org.snmp4j.Snmp;
import org.snmp4j.Target;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.UdpAddress;

public interface SNMPContext {
    default public void setupTargetBasicProperties(Target target, SNMPConfiguration configuration) {
        int snmpVersion = configuration.getVersion();
        String host = configuration.getTargetHost();
        String port = configuration.getTargetPort();
        int retries = configuration.getRetries();
        long timeout = configuration.getTimeoutInMs();
        target.setVersion(snmpVersion);
        target.setAddress((Address)new UdpAddress(host + "/" + port));
        target.setRetries(retries);
        target.setTimeout(timeout);
    }

    public Snmp createSnmpManagerInstance(SNMPConfiguration var1);

    public Target createTargetInstance(SNMPConfiguration var1);
}

