/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.services.smb;

import com.hierynomus.msdtyp.AccessMask;
import com.hierynomus.mserref.NtStatus;
import com.hierynomus.msfscc.FileAttributes;
import com.hierynomus.msfscc.fileinformation.FileIdBothDirectoryInformation;
import com.hierynomus.mssmb2.SMB2CreateDisposition;
import com.hierynomus.mssmb2.SMB2CreateOptions;
import com.hierynomus.mssmb2.SMB2ShareAccess;
import com.hierynomus.mssmb2.SMBApiException;
import com.hierynomus.smbj.session.Session;
import com.hierynomus.smbj.share.Directory;
import com.hierynomus.smbj.share.DiskShare;
import com.hierynomus.smbj.share.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.nifi.services.smb.SmbClientService;
import org.apache.nifi.services.smb.SmbException;
import org.apache.nifi.services.smb.SmbListableEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SmbjClientService
implements SmbClientService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SmbjClientService.class);
    private static final List<String> SPECIAL_DIRECTORIES = Arrays.asList(".", "..");
    private static final long UNCATEGORIZED_ERROR = -1L;
    private final Session session;
    private final DiskShare share;
    private final URI serviceLocation;

    SmbjClientService(Session session, DiskShare share, URI serviceLocation) {
        this.session = session;
        this.share = share;
        this.serviceLocation = serviceLocation;
    }

    public void close() {
        try {
            if (this.session != null) {
                this.session.close();
            }
        }
        catch (Exception e) {
            LOGGER.error("Could not close session to {}", (Object)this.serviceLocation, (Object)e);
        }
    }

    public Stream<SmbListableEntity> listFiles(String directoryPath) {
        return Stream.of(directoryPath).flatMap(path -> {
            Directory directory = this.openDirectory((String)path);
            return (Stream)StreamSupport.stream(() -> directory.spliterator(), 0, false).map(entity -> this.buildSmbListableEntity((FileIdBothDirectoryInformation)entity, (String)path, this.serviceLocation)).filter(entity -> !this.specialDirectory((SmbListableEntity)entity)).flatMap(listable -> listable.isDirectory() ? this.listFiles(listable.getPathWithName()) : Stream.of(listable)).onClose(() -> ((Directory)directory).close());
        });
    }

    public void ensureDirectory(String directoryPath) {
        block6: {
            try {
                int lastDirectorySeparatorPosition = directoryPath.lastIndexOf("/");
                if (lastDirectorySeparatorPosition > 0) {
                    this.ensureDirectory(directoryPath.substring(0, lastDirectorySeparatorPosition));
                }
                if (this.share.folderExists(directoryPath)) break block6;
                try {
                    this.share.mkdir(directoryPath);
                }
                catch (SMBApiException e) {
                    if (e.getStatus() == NtStatus.STATUS_OBJECT_NAME_COLLISION && !this.share.folderExists(directoryPath)) {
                        throw e;
                    }
                }
            }
            catch (Exception e) {
                throw this.wrapException(e);
            }
        }
    }

    public void readFile(String filePath, OutputStream outputStream) throws IOException {
        try (File file = this.share.openFile(filePath, EnumSet.of(AccessMask.GENERIC_READ), EnumSet.of(FileAttributes.FILE_ATTRIBUTE_NORMAL), EnumSet.of(SMB2ShareAccess.FILE_SHARE_READ), SMB2CreateDisposition.FILE_OPEN, EnumSet.of(SMB2CreateOptions.FILE_SEQUENTIAL_ONLY));){
            file.read(outputStream);
        }
        catch (Exception e) {
            throw this.wrapException(e);
        }
        finally {
            outputStream.close();
        }
    }

    public void moveFile(String filePath, String directoryPath) {
        try (File file = this.share.openFile(filePath, EnumSet.of(AccessMask.GENERIC_WRITE, AccessMask.DELETE), EnumSet.of(FileAttributes.FILE_ATTRIBUTE_NORMAL), EnumSet.noneOf(SMB2ShareAccess.class), SMB2CreateDisposition.FILE_OPEN, EnumSet.of(SMB2CreateOptions.FILE_SEQUENTIAL_ONLY));){
            String[] parts = filePath.split("/");
            String newFilePath = directoryPath.replace('/', '\\') + "\\" + parts[parts.length - 1];
            file.rename(newFilePath);
        }
        catch (Exception e) {
            throw this.wrapException(e);
        }
    }

    public void deleteFile(String filePath) {
        try {
            this.share.rm(filePath);
        }
        catch (Exception e) {
            throw this.wrapException(e);
        }
    }

    private SmbListableEntity buildSmbListableEntity(FileIdBothDirectoryInformation info, String path, URI serviceLocation) {
        return SmbListableEntity.builder().setName(info.getFileName()).setShortName(info.getShortName()).setPath(path).setLastModifiedTime(info.getLastWriteTime().toEpochMillis()).setCreationTime(info.getCreationTime().toEpochMillis()).setChangeTime(info.getChangeTime().toEpochMillis()).setLastAccessTime(info.getLastAccessTime().toEpochMillis()).setDirectory((info.getFileAttributes() & FileAttributes.FILE_ATTRIBUTE_DIRECTORY.getValue()) != 0L).setSize(info.getEndOfFile()).setAllocationSize(info.getAllocationSize()).setServiceLocation(serviceLocation).build();
    }

    private Directory openDirectory(String path) {
        return this.share.openDirectory(path, EnumSet.of(AccessMask.GENERIC_READ), EnumSet.of(FileAttributes.FILE_ATTRIBUTE_DIRECTORY), EnumSet.of(SMB2ShareAccess.FILE_SHARE_READ), SMB2CreateDisposition.FILE_OPEN, EnumSet.of(SMB2CreateOptions.FILE_DIRECTORY_FILE));
    }

    private boolean specialDirectory(SmbListableEntity entity) {
        return SPECIAL_DIRECTORIES.contains(entity.getName());
    }

    private SmbException wrapException(Exception e) {
        if (e instanceof SmbException) {
            return (SmbException)e;
        }
        long errorCode = e instanceof SMBApiException ? ((SMBApiException)((Object)e)).getStatusCode() : -1L;
        return new SmbException(e.getMessage(), errorCode, e);
    }
}

