/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.slack.consume;

import com.slack.api.methods.response.users.UsersInfoResponse;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processors.slack.consume.ConsumeSlackClient;
import org.apache.nifi.processors.slack.util.SlackResponseUtil;

public class UsernameLookup {
    private final ConcurrentMap<String, String> userIdToNameMapping = new ConcurrentHashMap<String, String>();
    private final ConsumeSlackClient client;
    private final ComponentLog logger;

    public UsernameLookup(ConsumeSlackClient client, ComponentLog logger) {
        this.client = client;
        this.logger = logger;
    }

    public String getUsername(String userId) {
        String cachedUsername = (String)this.userIdToNameMapping.get(userId);
        if (cachedUsername != null) {
            return cachedUsername;
        }
        try {
            UsersInfoResponse response = this.client.fetchUsername(userId);
            if (response.isOk()) {
                String username = response.getUser().getName();
                this.userIdToNameMapping.put(userId, username);
                return username;
            }
            String errorMessage = SlackResponseUtil.getErrorMessage(response.getError(), response.getNeeded(), response.getProvided(), response.getWarning());
            this.logger.warn("Failed to retrieve Username for User ID {}: {}", new Object[]{userId, errorMessage});
            return null;
        }
        catch (Exception e) {
            if (SlackResponseUtil.isRateLimited(e)) {
                this.logger.warn("Failed to retrieve Username for User ID {} because the Rate Limit has been exceeded", new Object[]{userId});
            } else {
                this.logger.warn("Failed to retrieve Username for User ID {}: {}", new Object[]{userId, e.getMessage(), e});
            }
            return null;
        }
    }
}

